% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{get_germplasm_attributes}
\alias{get_germplasm_attributes}
\title{Retrieve Attributes for a Specified Germplasm}
\usage{
get_germplasm_attributes(germplasm_name = "")
}
\arguments{
\item{germplasm_name}{The name of the germplasm.}
}
\value{
A data frame containing the attributes associated with the specified germplasm.
}
\description{
Retrieves a detailed list of attributes for a given germplasm, such as its origin, donors, and taxonomic information.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()
  set_crop("wheat")
  germplasm_attributes <- get_germplasm_attributes("Jabal")
}

}
\seealso{
\code{\link{login_bms}}, \code{\link{set_crop}}, \code{\link{get_germplasm_data}}
}
\author{
Johan Steven Aparicio, \email{j.aparicio@cgiar.org}
}
