% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-plate.R
\name{plot_counts}
\alias{plot_counts}
\title{Plot counts in a 96-well plate}
\usage{
plot_counts(
  plate,
  analyte_name,
  plot_counts = TRUE,
  plot_legend = FALSE,
  lower_threshold = 50,
  higher_threshold = 70
)
}
\arguments{
\item{plate}{The plate object with the counts data}

\item{analyte_name}{The name of the analyte}

\item{plot_counts}{Logical indicating if the counts should be plotted}

\item{plot_legend}{Logical indicating if the legend should be plotted}

\item{lower_threshold}{The lower threshold for the counts, it separates green and yellow colors}

\item{higher_threshold}{The higher threshold for the counts, it separates yellow and red colors}
}
\value{
A ggplot object
}
\description{
This is a function used to plot counts in a 96-well plate using a color to represent the count ranges.
There is possibility to plot exact counts in each well. \cr \cr
If plot window is resized, it's best to re-run the function to adjust the scaling.
Sometimes when legend is plotted, whole layout may be shifted, then it's best to stretch the window, and everything will be adjusted automatically.
}
\examples{
plate_filepath <- system.file("extdata", "CovidOISExPONTENT_CO.csv",
  package = "PvSTATEM", mustWork = TRUE
)
layout_filepath <- system.file("extdata", "CovidOISExPONTENT_CO_layout.xlsx",
  package = "PvSTATEM", mustWork = TRUE
)
plate <- read_luminex_data(plate_filepath, layout_filepath)
plot_counts(
  plate = plate, analyte_name = "OC43_NP_NA",
  plot_counts = TRUE, plot_legend = FALSE
)

}
