% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MidwestMutual.R
\docType{data}
\name{MidwestMutual}
\alias{MidwestMutual}
\title{Midwest Family Mutual Insurance Company data}
\format{
\subsection{MidwestMutual}{

A simple \code{10x10} matrix of a class \code{triangle} with ten origin years
(rows) each being fully developed within ten consecutive development
periods/years (columns)

\describe{
\item{origin}{matrix rows with the occurrence year (origin)}
\item{dev}{matrix columns with the development period (development)}
}
}
}
\source{
\url{https://www.casact.org/publications-research/research/research-resources}\cr
(Other Liability Data Set, NAIC group code: 23574)
}
\usage{
data(MidwestMutual)
}
\description{
An illustrative dataset---a matrix (of the dimensions 10\code{x}10) with ten
completed years of claims payment developments of the Midwest Family Mutual
Insurance company from the period 1988 -- 1997.  The data matrix contains ten
origin/occurrence years (with the first row representing the incident year
1988) and ten consecutive development periods/years (in columns).
}
\details{
The run-off triangle (the upper-left triangular part of the data matrix)
contains only positive increments making the triangle suitable for the
standard modelling approach---the over-dispersed Poisson model (GLM approach).

In practice, the run-off triangle only (the upper triangular part) of the data
matrix is known while the bottom-right triangular part is treated as a future
outcome (an "unknown" truth) that should be estimated/predicted.
The Midwest Family Mutual Insurance data matrix is fully observed to allow for
some retrospective goodness-of-fit evaluations.
}
\references{
Meyers, G. G. and P. Shi (2011). Loss reserving data pulled
from NAIC Schedule P. Available from
\url{https://www.casact.org/publications-research/research/research-resources}

Maciak, M., Mizera, I., and Pešta, M. (2022). Functional Profile
Techniques for Claims Reserving. ASTIN Bulletin, 52(2), 449-482. DOI:10.1017/asb.2022.4
(Portfolio #2)
}
