% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxAUC.R
\name{toxAUC}
\alias{toxAUC}
\title{Create longitudinal mean score line plots for PRO-CTCAE data with modified
Area Under the Curve (AUC) estimates showing descriptive symptomatic adverse
event burden worsening and improvement from baseline.}
\usage{
toxAUC(
  dsn,
  id_var,
  cycle_var,
  baseline_val,
  arm_var = NA,
  auc = "above",
  cycle_limit = NA,
  y_limit = 4,
  tab_ymin = NA,
  tab_ymax = NA,
  round_dec = 2,
  permute_tests = FALSE,
  permute_n = 2000,
  bootstrap_ci = FALSE,
  bootstrap_ci_alpha = 0.05,
  bootstrap_n = 2000,
  arm_colors = NA,
  x_label = NA,
  add_item_title = FALSE,
  cycle_label = FALSE,
  cycle_vals = NA,
  cycle_labs = NA
)
}
\arguments{
\item{dsn}{A data.frame object with PRO-CTCAE data}

\item{id_var}{A character string. Name of ID variable differentiating each
unique patient.}

\item{cycle_var}{A character string. Name of variable differentiating one
longitudinal/repeated. PRO-CTCAE survey from another, within an individual
ID.}

\item{baseline_val}{A number indicating the expected baseline cycle/time
point.}

\item{arm_var}{A character string. Name of arm variable differentiating
treatment groups. Must be character or factor class. Overall frequencies
will be reported if no arm/grouping variable is provided. Defaults to
\code{NA}.}

\item{auc}{A character string. Specifies the partitioning of area shown.
options include: \code{"above"} = accumulated area above the baseline
horizontal can be interpreted as worsening severity from baseline.
\code{"below"} = accumulated area below the baseline horizontal can be
interpreted the as the amount of decreased severity from baseline.
\code{"both"} = accumulated area above and below the baseline horizontal
are shown. Defaults to \code{"above"}.}

\item{cycle_limit}{A number. Limit the number of cycles to be use to
calculate the AUC metrics up to and including a given cycle number.
All available cycle time points are used if no cycle number is provided.
Defaults to \code{NA}.}

\item{y_limit}{A number. Y axis limit for plots. Defaults to \code{4}.}

\item{tab_ymin}{A number. Y axis coordinate for adjusting the vertical
placement of the AUC table within the figure. Defaults to \code{NA}.}

\item{tab_ymax}{A number. Y axis coordinate for adjusting the vertical
placement of the AUC table within the figure. Defaults to \code{NA}.}

\item{round_dec}{A number. Number of decimal places to be shown within
the AUC table. Defaults to \code{2}.}

\item{permute_tests}{Logical. Calls to calculate p values comparing the
difference in AUC between two arms using a permutation test. Typical two-
sided null hypothesis for a permutation test is applied. That is, assigning
subjects to groups is interchangeable when calculating AUC. Computation
time may be extensive depending on data size, number of PRO-CTCAE items,
and number of permutations called. Consider staring out an open window or
crafting a haiku during this time. Defaults to \code{FALSE}.}

\item{permute_n}{A number. The number of permutations to be used for
permutation tests. Defaults to \code{2000}.}

\item{bootstrap_ci}{Logical. Calls to construct alpha-level confidence
intervals for the difference in AUC between arms. Similar considerations
for computation time as \code{permute_tests} are recommended here. Defaults
to \code{FALSE}.}

\item{bootstrap_ci_alpha}{A number. Specifies the alpha level for bootstrap
confidence intervals. Must be between 0 and 1. Defaults to \code{0.05}.}

\item{bootstrap_n}{A number. The number of bootstrap iterations to be used
for bootstrap confidence intervals. Defaults to \code{2000}.}

\item{arm_colors}{A column vector of valid colors. Allows the user to define
the colors of arms shown in the returned figure. Column vector must have
length greater than or equal to the number of arms. Default colors
provided.}

\item{x_label}{A character string. Label for the x axis of the plot. Defaults
to \code{NA} resulting in x axis labeled with \code{cycle_var} variable
name.}

\item{add_item_title}{Logical. Adds the item short label to the title of
each figure. Defaults to \code{FALSE}.}

\item{cycle_label}{Logical. Assign custom labels to cycles/time point. If
\code{TRUE}, the \code{cycle_vals} and \code{cycle_labs} must also be specified.}

\item{cycle_vals}{Numeric column vector. Vector of values seen within the
\code{cycle_var} variable. Must be same length of \code{cycle_labs}. Defaults
to \code{NA}.}

\item{cycle_labs}{Character column vector. Vector of labels to be mapped to
the associated \code{cycle_vals}. Must be same length of \code{cycle_vals}.
Defaults to \code{NA}.}
}
\description{
Data format should be in 'long' format, where each PRO-CTCAE item is a
	  variable/column. AUC calculations will only include subjects with non-
	  missing baseline values (within each PRO-CTCAE item).
}
\examples{
\dontrun{
AUC=toxAUC(dsn = ProAE::tox_acute,
id_var = "id",
cycle_var = "Cycle",
baseline_val = 1)
AUC[[1]]
}
}
