% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_predict.R
\name{pop.predict2}
\alias{pop.predict2}
\alias{pop_predict2}
\title{Predict genetic variance and genetic correlations in bi-parental populations using a deterministic model}
\usage{
pop.predict2(
  G.in,
  y.in,
  map.in,
  crossing.table,
  parents,
  tail.p = 0.1,
  self.gen = Inf,
  DH = FALSE,
  models = c("rrBLUP", "BayesA", "BayesB", "BayesC", "BL", "BRR"),
  ...
)

pop_predict2(
  M,
  y.in,
  marker.effects,
  map.in,
  crossing.table,
  parents,
  tail.p = 0.1,
  self.gen = Inf,
  DH = FALSE,
  models = c("rrBLUP", "BayesA", "BayesB", "BayesC", "BL", "BRR"),
  ...
)
}
\arguments{
\item{G.in}{See \code{G.in} in \code{\link[PopVar]{pop.predict}}.}

\item{y.in}{See \code{y.in} in \code{\link[PopVar]{pop.predict}}.}

\item{map.in}{See \code{map.in} in \code{\link[PopVar]{pop.predict}}.}

\item{crossing.table}{See \code{crossing.table} in \code{\link[PopVar]{pop.predict}}.}

\item{parents}{See \code{parents} in \code{\link[PopVar]{pop.predict}}.}

\item{tail.p}{See \code{tail.p} in \code{\link[PopVar]{pop.predict}}.}

\item{self.gen}{The number of selfing generations in the potential cross. Can be an integer or \code{Inf} for
recombinant inbreds. Note: \code{self.gen = 1} corresponds to an F2 population.}

\item{DH}{Indicator if doubled-haploids are to be induced after the number of selfing generations indicated by
\code{self.gen}. For example, if \code{self.gen = 0} and \code{DH = TRUE}, then doubled-haploids are assumed
to be induced using gametes from F1 plants.}

\item{models}{See \code{models} in \code{\link[PopVar]{pop.predict}}.}

\item{...}{Additional arguments to pass depending on the choice of \code{model}.}

\item{M}{A Matrix of marker genotypes of dimensions \code{nLine} x \code{nMarker}, coded as
-1, 0, and 1.}

\item{marker.effects}{A data frame of marker effects. The first column should include the marker name and
subsequent columns should include the marker effects. Supercedes \code{y.in} if passed.}
}
\description{
Generates predictions of the genetic variance and genetic correlation in bi-parental populations using a set of deterministic equations instead of simulations.
}
\details{
Predictions are based on the deterministic equations specified by Zhong and Jannink (2007), Allier et al. (2019),
and Neyhart et al. (2019).
}
\section{Functions}{
\itemize{
\item \code{pop_predict2}: 
}}

\examples{

\dontrun{

# Load data
data("think_barley")

# Use example data to make predictions
out <- pop.predict2(G.in = G.in_ex_imputed, y.in = y.in_ex, map.in = map.in_ex, 
                    crossing.table = cross.tab_ex)
                    
# Provide a vector of parents to predict all possible crosses (some parents
# have missing phenotypic data)
out <- pop.predict2(G.in = G.in_ex_imputed, y.in = y.in_ex, map.in = map.in_ex, 
                    parents = y.in_ex$Entry[1:5])
                    
# Make predictions for 5 crosses with various levels of inbreeding
out_list <- lapply(X = 1:10, FUN = function(self.gen) {
  out <- pop.predict2(G.in = G.in_ex_imputed, y.in = y.in_ex, map.in = map.in_ex, 
                      crossing.table = cross.tab_ex[1:5,], self.gen = self.gen)
  out$self.gen <- self.gen
  out })
               
# Plot predictions of grain yield genetic variance over levels of inbreeding
dat <- do.call("rbind", lapply(out_list, subset, trait == "Yield"))
plot(pred_varG ~ self.gen, data = dat, type = "b", 
     subset = parent1 == parent1[1] & parent2 == parent2[1])

}


# Load data
data("think_barley")

# Use example data to make predictions
out <- pop_predict2(M = G.in_ex_mat, y.in = y.in_ex, map.in = map.in_ex, 
                    crossing.table = cross.tab_ex)
                    
# Provide a vector of parents to predict all possible crosses (some parents
# have missing phenotypic data)
out <- pop_predict2(M = G.in_ex_mat, y.in = y.in_ex, map.in = map.in_ex, 
                    parents = y.in_ex$Entry[1:10])
                    
# Make predictions for 5 crosses with various levels of inbreeding
out_list <- lapply(X = 1:10, FUN = function(self.gen) {
  out <- pop_predict2(M = G.in_ex_mat, y.in = y.in_ex, map.in = map.in_ex, 
                      crossing.table = cross.tab_ex[1:5,], self.gen = self.gen)
  out$self.gen <- self.gen
  out })
               
# Plot predictions of grain yield genetic variance over levels of inbreeding
dat <- do.call("rbind", lapply(out_list, subset, trait == "Yield"))
plot(pred_varG ~ self.gen, data = dat, type = "b", 
     subset = parent1 == parent1[1] & parent2 == parent2[1])

}
\references{
Zhong, S., and J.-L. Jannink, 2007 Using quantitative trait loci results to discriminate among crosses on the basis of their
progeny mean and variance. Genetics 177: 567–576. https://doi.org/10.1534/ genetics.107.075358

Allier, A., L. Moreau, A. Charcosset, S. Teyssèdre, and C. Lehermeier, 2019 Usefulness Criterion and Post-selection Parental
Contributions in Multi-parental Crosses: Application to Polygenic Trait Introgression. G3 9: 1469–1479.
doi: 10.1534/g3.119.400129

Neyhart, J.L., A.J. Lorenz, and K.P. Smith, 2019 Multi-trait Improvement by Predicting Genetic Correlations in Breeding
Crosses. G3 9: 3153-3165. doi: 10.1534/g3.119.400406
}
