% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_call_recon.R
\name{VDJ_call_RECON}
\alias{VDJ_call_RECON}
\title{Calls the Kaplinsky/RECON tool}
\usage{
VDJ_call_RECON(
  VDJ,
  recon.directory,
  feature.columns,
  grouping.column,
  VDJ.VJ.1chain,
  max.features,
  size.threshold,
  resample,
  max.feature.size,
  reticulate,
  operating.system
)
}
\arguments{
\item{VDJ}{VDJ or VDJ.GEX.matrix[[1]] object, as obtained from the VDJ_GEX_matrix function in Platypus.}

\item{recon.directory}{directory containing recon executable. Defaults to {working directory}/Recon}

\item{feature.columns}{vector of strings/ string - columns denoting the unique species for RECON - e.g., could be the CDRH3s if feature.columns = 'VDJ_cdr3s_aa'. If more than one column is provided (e.g. c("VDJ_cdr3s_aa","VJ_cdr3s_aa")) these columns will be pasted together.}

\item{grouping.column}{string - column determining the groups/ samples for the species observations. Defaults to 'sample_id' for per-repertoire analysis}

\item{VDJ.VJ.1chain}{boolean, defaults to TRUE. Whether to filter out aberrant cells (more than 1 VDJ or VJ chain).}

\item{max.features}{integer or 'all' - maximum number of features/species ot be considered for the RECON estimation. If 'all', will consider all species.}

\item{size.threshold}{integer - the size threshold parameter for the RECON tool, as specified by the '-t' parameter.}

\item{resample}{boolean - if T, will also perform and output a resample of the species frequencies/sizes from the inferred parent distribution.}

\item{max.feature.size}{integer - the maximum size of species/features to be considered in the resulting plot (maximum number of elements on the x axis).}

\item{reticulate}{boolean - if T, will create a new environment to install python and run the RECON tool, else, your environment must have a python version compatible with RECON installed.}

\item{operating.system}{string - operating system on which RECON will be run. 'Windows' for Windows, 'Linux' for Linux, 'Darwin' for MacOS.}
}
\value{
The resulting means and weights of the RECON-inferred distribution as a seprate dataframe or appended to the VDJ, or a plot of resampled species sizes from the inferred distribution vs original sizes/frequencies.
}
\description{
Calls the Kaplinsky/RECON tool on the VDJ/VDJ.GEX.matrix[[1]] object to infer the parent distribution of species and estimate their diversity. Outputs either a dataframe of the resulting means and weights of the RECON species parent distribution estimation or a plot of the original species distribution along resampled values from the reconstructed parent distribution.
}
\examples{
\dontrun{
VDJ_call_RECON(VDJ, recon.directory='./Recon',
feature.columns = 'VDJ_cdr3s_aa', grouping.column = 'VDJ_cdr3s_aa')
}
}
