% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbForests_ConvertStructure.R
\name{AbForests_ConvertStructure}
\alias{AbForests_ConvertStructure}
\title{Extract transcriptome/isotype information and B cell receptor sequences from single cell immune repertoire formatted as list of data.frames}
\usage{
AbForests_ConvertStructure(list, opt, cdr3)
}
\arguments{
\item{list}{a list of data.frames. Each data.frame may contain information concerning full length heavy and light chain sequences, CDRH3 and CDRL3 sequences, the type of isotype and the transcriptional cluster that corresponds to each of these sequences.}

\item{opt}{a string with options "isotype" and "cluster". The option "isotype" is utilized when the user desires to do an isotype analysis, while the selection of "cluster" denotes that an analysis based on transcriptome is requested.}

\item{cdr3}{variable with values 0 if the user desires to select full length sequences (only when the input is a list of csv files), 1 for sequences in the CDR3 only (only when the input is a list of csv files) and NULL otherwise.}
}
\value{
list a list of data.frames. Each data.frame contains 2 columns, one that describes the sequences and the other which type of information (isotype or cluster) is considered in the analysis. All these cases are determined by the user.
}
\description{
ConvertStructure alters a list of clone lineages, represented as data.frames and recovers the type of isotypes or transcriptional clusters and antibody sequences from these clone lineages. It can receive as input the original data or the output of SubRepertoiresByUniqueSeq or SubRepertoiresByCells. Then, the output list is used as input to the RemoveNets or AntibodyForest function.
}
\examples{
\dontrun{
ConvertStructure(list,opt="cluster",cdr3=NULL)
ConvertStructure(list,opt="isotype",1)
}
}
\seealso{
RemoveNets, AntibodyForest
}
