% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCodelistAttribute.R
\name{addCodelistAttribute}
\alias{addCodelistAttribute}
\title{Adds the cohort_codelist attribute to a cohort}
\usage{
addCodelistAttribute(cohort, codelist, cohortName = names(codelist))
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{codelist}{Named list of concepts}

\item{cohortName}{For each element of the codelist, the name of the cohort in
`cohort` to which the codelist refers}
}
\value{
A cohort
}
\description{
`addCodelistAttribute()` allows the users to add a codelist to a cohort in
OMOP CDM.

This is particularly important for the use of `codelistDiagnostics()`, as the
underlying assumption is that the cohort that is fed into
`codelistDiagnostics()` has a cohort_codelist attribute attached to it.
}
\examples{
\donttest{
library(PhenotypeR)

cdm <- mockPhenotypeR()

cohort <- addCodelistAttribute(cohort = cdm$my_cohort, codelist = list("cohort_1" = 1L))
attr(cohort, "cohort_codelist")

CDMConnector::cdmDisconnect(cdm)
}
}
