% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_kokanee_tagloss}
\alias{data_kokanee_tagloss}
\title{Capture-recapture on Kokanee in Metolius River with tag loss}
\format{
\subsection{\code{data_kokanee_tagloss}}{

A data frame with many rows and 2 columns

\describe{
\item{\code{cap_hist}.}{Capture history (1000, 1010, 1100, 1110, 1111).}
\item{\code{freq}.}{Number of fish with this history. Always 1}
}
}
}
\usage{
data(data_kokanee_tagloss)
}
\description{
This is the data from  Hyun et al (2012).
In August and September 2007, the period just before the spawning run,
adult kokanee were collected by beach seining in the upper arm of the
lake near the confluence with the Metolius River.
Fish were tagged with nonpermanent, plastic T-bar anchor tags
and then were released back into the lake.
Randomly selected fish received single tags of one color,
while the other fish received two tags of a second color (i.e., the double tags were identical in color).
In late September through October, spawning ground surveys were conducted by 2–3 people walking
abreast in a downstream direction (or floating, in sections where the water depth and flow were too great to allow walking).
Instead of being physically recaptured, the fish were resighted as they swam freely in the clear,
relatively shallow water within the spawning areas of the river.
The total number of fish observed with or without a tag (or tags) was recorded for each section,
and information on the number and color of tags for each marked fish was also noted.
}
\details{
Because fish were not handled, it is not possible to know which of the double tags were lost, and so only
models with equal retention probabilities and non-distinguishable double tags should be fit. Note
that the capture history for a lost of 1 indistinguishable tag is 111X rather than 1110 or 1101 (both of
which are not allowed in the model with indistinguishable double tags)
}
\keyword{datasets}
