% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiagnosePlp.R
\name{diagnoseMultiplePlp}
\alias{diagnoseMultiplePlp}
\title{Run a list of predictions diagnoses}
\usage{
diagnoseMultiplePlp(
  databaseDetails = createDatabaseDetails(),
  modelDesignList = list(createModelDesign(targetId = 1, outcomeId = 2, modelSettings =
    setLassoLogisticRegression()), createModelDesign(targetId = 1, outcomeId = 3,
    modelSettings = setLassoLogisticRegression())),
  cohortDefinitions = NULL,
  logSettings = createLogSettings(verbosity = "DEBUG", timeStamp = TRUE, logName =
    "diagnosePlp Log"),
  saveDirectory = NULL
)
}
\arguments{
\item{databaseDetails}{The database settings created using \code{createDatabaseDetails()}}

\item{modelDesignList}{A list of model designs created using \code{createModelDesign()}}

\item{cohortDefinitions}{A list of cohort definitions for the target and outcome cohorts}

\item{logSettings}{The setting spexcifying the logging for the analyses created using \code{createLogSettings()}}

\item{saveDirectory}{Name of the folder where all the outputs will written to.}
}
\value{
A data frame with the following columns: \tabular{ll}{ \verb{analysisId} \tab The unique identifier
for a set of analysis choices.\cr \verb{targetId} \tab The ID of the target cohort populations.\cr
\verb{outcomeId} \tab The ID of the outcomeId.\cr \verb{dataLocation} \tab The location where the plpData was saved
\cr \verb{the settings ids} \tab The ids for all other settings used for model development.\cr }
}
\description{
Run a list of predictions diagnoses
}
\details{
This function will run all specified prediction design diagnoses.
}
