% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CollectiveModelMethods.R
\name{Excess_Frequency}
\alias{Excess_Frequency}
\title{Expected Frequency in Excess of a Threshold}
\usage{
Excess_Frequency(CollectiveModel, x = 0)
}
\arguments{
\item{CollectiveModel}{A collective model object. Currently only \code{PPP_Models} are handled.}

\item{x}{Numeric. Threshold.}
}
\value{
The expected frequency in excess of \code{x} for the given \code{CollectiveModel}
}
\description{
Calculates the expected frequency in excess of a threshold for a collective model
}
\examples{
PPPM <- PiecewisePareto_Match_Layer_Losses(Example1_AP, Example1_EL)
PPPM
Excess_Frequency(PPPM, c(-Inf, 0, 1000, 2000, 3000, Inf))

}
