% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpPUlasso.R
\name{grpPUlasso}
\alias{grpPUlasso}
\title{Solve PU problem with lasso or group lasso penalty.}
\usage{
grpPUlasso(X, z, pi, initial_coef = NULL, group = 1:ncol(X),
  penalty = NULL, lambda = NULL, nlambda = 100,
  lambdaMinRatio = ifelse(N < p, 0.05, 0.005), maxit = 1e+05, eps = 1e-04,
  inner_eps = 0.01, verbose = FALSE)
}
\arguments{
\item{X}{Input matrix; each row is an observation. Can be in matrix, sparse matrix or big matrix format.}

\item{z}{Response vector representing whether an observation is labelled or unlabelled.}

\item{pi}{True prevalence Pr(Y=1)}

\item{initial_coef}{A vector representing an initial point where we start PUlasso algorithm from.}

\item{group}{A vector representing grouping of the coefficients. For the least ambiguity, it is recommended if group is provided in the form of vector of consecutive ascending integers.}

\item{penalty}{penalty to be applied to the model. Default is sqrt(group size) for each of the group.}

\item{lambda}{A user supplied sequence of lambda values. If unspecified, the function automatically generates its own lambda sequence based on nlambda and lambdaMinRatio.}

\item{nlambda}{The number of lambda values.}

\item{lambdaMinRatio}{Smallest value for lambda, as a fraction of lambda.max which leads to the intercept only model.}

\item{maxit}{Maximum number of iterations.}

\item{eps}{Convergence threshold for the outer loop. The algorithm iterates until the maximum change in coefficients is less than eps in the outer loop.}

\item{inner_eps}{Convergence threshold for the inner loop. The algorithm iterates until the maximum change in coefficients is less than eps in the inner loop.}

\item{verbose}{a logical value. if TRUE, the function prints out the fitting process.}
}
\value{
coef A p by length(lambda) matrix of coefficients

std_coef A p by length(lambda) matrix of coefficients in a standardized scale

lambda The actual sequence of lambda values used.

nullDev Null deviance defined to be 2*(logLik_sat -logLik_null)

deviance Deviance defined to be 2*(logLik_sat -logLik(model))

iters number of iterations
}
\description{
Fit a model using PUlasso algorithm over a regularization path. The regularization path is computed at a grid of values for the regularization parameter lambda.
}
\examples{
data("simulPU")
fit<-grpPUlasso(X=simulPU$X,z=simulPU$z,pi=simulPU$truePY1)
}
