% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLmixed_main_function.R
\name{PLmixed}
\alias{PLmixed}
\title{Fit GLMM with Factor Structure}
\usage{
PLmixed(
  formula,
  data,
  family = gaussian,
  load.var = NULL,
  lambda = NULL,
  factor = NULL,
  init = 1,
  nlp = NULL,
  init.nlp = 1,
  nAGQ = 1,
  method = "L-BFGS-B",
  lower = -Inf,
  upper = Inf,
  lme4.optimizer = "bobyqa",
  lme4.start = NULL,
  lme4.optCtrl = list(),
  opt.control = NULL,
  REML = FALSE,
  SE = 1,
  ND.method = "simple",
  check = "stop",
  est = TRUE,
  iter.count = TRUE
)
}
\arguments{
\item{formula}{A formula following that of \pkg{\link{lme4}}, with the addition that factors can be specified
as random effects. Factor names should not be names of variables in the data set, and are instead
defined with the \code{factor} argument.}

\item{data}{A data frame containing the variables used in the model (but not factor names).}

\item{family}{A GLM family, see \code{\link{glm}} and \code{\link{family}}.}

\item{load.var}{A variable in the dataframe identifying what the factors load onto. Each unique element in \code{load.var} will have
a unique factor loading. All rows in the dataset with the same value for \code{load.var} will have the same factor loading.}

\item{lambda}{A matrix or list of matrices corresponding to the loading matrices. A value of NA
indicates the loading is freely estimated, while a numeric entry indicates a constraint.}

\item{factor}{A list of factors corresponding to the loading matrices and factors specified in model.}

\item{init}{A scalar (default = \code{1}) or vector of initial lambda values. If a scalar, the value is applied to all lambda parameters.
If a vector, the values apply in row by column by matrix order.}

\item{nlp}{A character vector containing the names of additional nonlinear parameters that are in the model formula.}

\item{init.nlp}{A scalar (default = \code{1}) or vector of initial nlp values. If a scalar, the value is applied to all nlp parameters.
If a vector, the values apply in the order listed.}

\item{nAGQ}{If family is non-gaussian, the number of points per axis for evaluating the adaptive
Gauss-Hermite approximation to the log-likelihood. Defaults to \code{1}, corresponding to the Laplace approximation.
See \code{\link{glmer}}.}

\item{method}{The \code{\link{optimx}} optimization method. Defaults to \code{L-BFGS-B}.}

\item{lower}{Lower bound on lambda parameters if applicable.}

\item{upper}{Upper bound on lambda parameters if applicable.}

\item{lme4.optimizer}{The \pkg{\link{lme4}} optimization method.}

\item{lme4.start}{Start values used for \pkg{\link{lme4}}.}

\item{lme4.optCtrl}{A list controlling the lme4 optimization. See \code{\link{lmerControl}}
or \code{\link{glmerControl}}}

\item{opt.control}{Controls for the \code{\link{optimx}} optimization.}

\item{REML}{Use REML if model is linear? Defaults to \code{FALSE}.}

\item{SE}{Method of calculating standard errors for fixed effects.}

\item{ND.method}{Method of calculating numerical derivatives.}

\item{check}{Check number of observations vs. levels and number of observations vd. random effects.}

\item{est}{Return parameter estimates.}

\item{iter.count}{Print the iteration counter during optimization.}
}
\value{
An object of class \code{PLmod}, which contains an object of class \code{merMod} as one of its elements.
Some functions for class \code{merMod} have been adapted to work with class \code{PLmod}. Others can be utilized
using \code{object$'lme4 Model'}, where \code{object} is an object of class \code{PLmod}.
}
\description{
Fit a (generalized) linear mixed effects model (GLMM) with factor structures. Utilizes both the
\pkg{\link{lme4}} package and \code{\link{optim}} function for estimation using a profile-likelihood based
approach.
}
\details{
Factors are listed within the \code{formula} in the same way that random effects are specified
in \pkg{\link{lme4}}. The grouping variable listed after \code{|} defines what the factor values randomly
vary over, just as \code{|} does for other random effects. The names of factors and other random
effect terms can be listed within the same set of parentheses, allowing the covariance between the
factor(s) and random effect(s) to be estimated. The same factor may be specified for multiple grouping
variables, allowing for multilevel or crossed effects.

The \code{factor} argument must list any factor that appears in the \code{formula}. The ordering will
depend on the ordering of the matrices listed within \code{lambda}. The matrices in \code{lambda}
specify the factor loading matrices. The number of matrices in \code{lambda} should equal the number
of character vectors in \code{factor} and the number of elements in \code{load.var}. The number of
rows in the \emph{k}th matrix listed in \code{lambda} should correspond to the number of unique elements
in the dataset for the \emph{k}th variable listed in \code{load.var}, and the number of columns in the \emph{k}th
matrix should correspond to the number of factors listed in the \emph{k}th character vector of \code{factor}.

Within the \emph{k}th matrix, the \emph{(i, j)} cell corresponds to the factor loading for the \emph{i}th unique element
of the \emph{k}th variable listed in \code{load.var} on the \emph{j}th factor listed in the \emph{k}th character vector
of \code{factor}. Each element of the matrix should be either a number or \code{NA}. If the element is a
number, the loading will be constrained to that value. If the element is an \code{NA}, the loading will
be freely estimated. For identification, it is necessary (but not sufficient) for at least one element in
each column to be constrained.

The \code{nlp} argument can be viewed as a special case of the \code{factor} argument, where the character vector
listed in \code{nlp} is automatically linked to 1 x p lambda matrix, where p is the number of elements in \code{nlp}.
The \code{load.var} for these parameters is viewed as a constant, so that the \code{nlp} parameters are equivalent for
all rows in the dataset. Thus, \code{nlp} simplifies the process of adding additional nonlinear parameters to the model
without having to specify corresponding \code{lambda} and \code{load.var} values.
}
\examples{
data("IRTsim") # Load the IRTsim data

IRTsub <- IRTsim[IRTsim$item < 4, ] # Select items 1-3
set.seed(12345)
IRTsub <- IRTsub[sample(nrow(IRTsub), 300), ] # Randomly sample 300 responses

IRTsub <- IRTsub[order(IRTsub$item), ] # Order by item
irt.lam = c(1, NA, NA) # Specify the lambda matrix

# Below, the # in front of family = binomial can be removed to change the response distribution
# to binomial, where the default link function is logit.

irt.model <- PLmixed(y ~ 0 + as.factor(item) + (0 + abil.sid |sid) +(0 + abil.sid |school),
                     data = IRTsub, load.var = c("item"), # family = binomial,
                     factor = list(c("abil.sid")), lambda = list(irt.lam))
summary(irt.model)

\dontrun{
# A more time-consuming example.
# ~ 5-10 minutes

data("KYPSsim") # Load the KYPSsim data

kyps.lam <- rbind(c( 1,  0),  # Specify the lambda matrix
                  c(NA,  0),
                  c(NA,  1),
                  c(NA, NA))

kyps.model <- PLmixed(esteem ~ as.factor(time) +  (0 + hs | hid)
                      + (0 + ms | mid) + (1 | sid), data = KYPSsim,
                      factor = list(c("ms", "hs")), load.var = c("time"),
                      lambda = list(kyps.lam))
summary(kyps.model)

data("JUDGEsim")
JUDGEsim <- JUDGEsim[order(JUDGEsim$item), ] # Order by item
unique(JUDGEsim$item)

# Specify Lambda matrix
judge.lam <- rbind(c( 1,  0,  1,  0,  0,  0),
                   c(NA,  0, NA,  0,  0,  0),
                   c(NA,  0, NA,  0,  0,  0),
                   c( 0,  1,  0,  1,  0,  0),
                   c( 0, NA,  0, NA,  0,  0),
                   c( 0, NA,  0, NA,  0,  0),
                   c( 0,  0,  0,  0,  1,  0),
                   c( 0,  0,  0,  0, NA,  0),
                   c( 0,  0,  0,  0, NA,  0),
                   c( 0,  0,  0,  0,  0,  1),
                   c( 0,  0,  0,  0,  0, NA),
                   c( 0,  0,  0,  0,  0, NA))

# Conduct analysis
judge.example <- PLmixed(response ~ 0 + as.factor(item) + (1 | class)
                         + (0 + trait1.t + trait2.t + trait1.s + trait2.s | stu)
                         + (0 + teacher1 + teacher2 | tch), data = JUDGEsim,
                         lambda = list(judge.lam), load.var = "item",
                         factor = list(c("teacher1", "teacher2", "trait1.t",
                                         "trait2.t", "trait1.s", "trait2.s")))

summary(judge.example)

data("KYPSitemsim")

time.lam <- rbind(c( 1,  0),  # Specify time lambda matrix
                  c(NA,  0),
                  c(NA,  1),
                  c(NA, NA))

item.lam <- c(1, NA, NA, NA, NA, NA) # Specify item lambda matrix

KYPSitemsim$time2 <- (KYPSitemsim$time == 2) * 1
KYPSitemsim$time3 <- (KYPSitemsim$time == 3) * 1
KYPSitemsim$time4 <- (KYPSitemsim$time == 4) * 1

kyps.item.model <- PLmixed(response ~ 0 + as.factor(item) + lat.var:time2
                           + lat.var:time3 + lat.var:time4 + (0 + hs:lat.var | hid)
                           + (0 + ms:lat.var | mid) + (0 + lat.var:as.factor(time) | id),
                           data = KYPSitemsim, lambda = list(time.lam, item.lam),
                           factor = list(c("ms", "hs"), "lat.var"),
                           load.var = c("time", "item"))

summary(kyps.item.model)

}

}
\references{
Rockwood, N. J., & Jeon, M. (2019). Estimating complex measurement and growth models
using the R package PLmixed.\emph{Multivariate Behavioral Research, 54}(2), 288-306.

Jeon, M., & Rabe-Hesketh, S. (2012). Profile-likelihood approach for estimating
generalized linear mixed models with factor structures. \emph{Journal of Educational
and Behavioral Statistics, 37}(4), 518-542.
}
\seealso{
\pkg{\link{lme4}}

\code{\link{glmer}}

\code{\link{lmer}}
}
\keyword{Factor}
\keyword{GLLAMM}
\keyword{GLMM}
\keyword{IRT}
