% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/injec_list.R
\name{combine_injec_lists}
\alias{combine_injec_lists}
\title{Create Sample List with rigorous design}
\usage{
combine_injec_lists(
  sample_lists,
  n_equi = 10,
  equi_pos,
  equi_prefix = Sys.Date(),
  equi_suffix = "equi",
  equi_injec_vol = 0.5
)
}
\arguments{
\item{sample_lists}{a list of sample lists}

\item{n_equi}{number of equilibriation injections}

\item{equi_pos}{position of equilibriation injections. For format check details}

\item{equi_prefix}{prefix for equilibriation injections}

\item{equi_suffix}{suffix for equilibriation injections}

\item{equi_injec_vol}{volume of equilibriation injection}
}
\value{
InjecListObj object
}
\description{
Create Sample List with rigorous design
}
\details{
The equi_pos format will be Row:Column format. E.g: "A,1"
}
