% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_conc}
\alias{assert_conc}
\alias{assert_time}
\alias{assert_conc_time}
\title{Verify that concentration measurements are valid}
\usage{
assert_conc(conc, any_missing_conc = TRUE)

assert_time(time, sorted_time = TRUE)

assert_conc_time(conc, time, any_missing_conc = TRUE, sorted_time = TRUE)
}
\arguments{
\item{conc}{Measured concentrations}

\item{any_missing_conc}{Are any concentration values allowed to be \code{NA}?}

\item{time}{Time of the measurement of the concentrations}

\item{sorted_time}{Must the time be unique and monotonically increasing?}
}
\value{
\code{conc} or give an informative error

\code{time} or give an informative error

A data.frame with columns named "conc" and "time" or an informative
error
}
\description{
If the concentrations or times are invalid, will provide an error.
Reasons for being invalid are
\itemize{
\item \code{time} is not a number
\item \code{conc} is not a number
\item Any \code{time} value is NA
\item \code{time} is not monotonically increasing
\item \code{conc} and \code{time} are not the same length
}
}
\details{
Some cases may generate warnings but allow the data to proceed.
\itemize{
\item A negative concentration is often but not always an
error; it will generate a warning.
}
}
