% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.simple.R
\name{pk.calc.count_conc}
\alias{pk.calc.count_conc}
\title{Count the number of concentration measurements in an interval}
\usage{
pk.calc.count_conc(conc, check = TRUE)
}
\arguments{
\item{conc}{Measured concentrations}

\item{check}{Run \code{\link[=assert_conc]{assert_conc()}}?}
}
\value{
a count of the non-missing concentrations (0 if all concentrations
are missing)
}
\description{
\code{count_conc} is typically used for quality control on the data to ensure that
there are a sufficient number of non-missing samples for a calculation and to
ensure that data are consistent between individuals.
}
\seealso{
Other NCA parameters for concentrations during the intervals: 
\code{\link{pk.calc.clast.obs}()},
\code{\link{pk.calc.cmax}()},
\code{\link{pk.calc.cstart}()},
\code{\link{pk.calc.ctrough}()}
}
\concept{NCA parameters for concentrations during the intervals}
