% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowFrailtyDat.R
\name{PowFrailtyDat}
\alias{PowFrailtyDat}
\title{A function to obtain a power table with the combination of
various number of PDX lines and number of individuals per PDX lines per treatment based on a preliminary dataset}
\usage{
PowFrailtyDat(
  data = NULL,
  formula = NULL,
  maxit = 50,
  hazard = "Weibull",
  n = NULL,
  m = NULL,
  sim = 1000,
  censor = FALSE,
  Ct = 5,
  two.sided = TRUE,
  alpha = 0.05,
  fixed.effect = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{data.frame in which to interpret the variables named in the formula.}

\item{formula}{a formula object, with the response on the left of a ~ operator, and the terms on the right.
The response must be a survival object as returned by the Surv function.}

\item{maxit}{maximum number of iterations needed for model fitting. Default is 50.}

\item{hazard}{distributional assumption of the baseline hazard. Default is Weibull.}

\item{n}{an integer number to specify the number of PDX lines.}

\item{m}{an integer number to specify the number of individuals per PDX line per treatment.}

\item{sim}{Number of Monte Carlo samples to be generated. Default is 1000.}

\item{censor}{logical value of whether a censoring distribution is considered in a data generation setting. Default is FALSE.}

\item{Ct}{a fixed time point when a study is designed to end for generating type 1 censoring data.}

\item{two.sided}{A logical value to indicate if a two-sided hypothesis testing is conducted. Default is TRUE.}

\item{alpha}{significance level. Default is 0.05.}

\item{fixed.effect}{logical value to indicate if a fixed effects only model is fitted. Default is FALSE.}

\item{ncores}{number of cores for parallel computation.}
}
\value{
Object of \code{PowFrailtyDat} with elements
\item{lambda}{the estimated scale parameter of Weibull baseline hazard from the pilot data.}
\item{nu}{the estimated shape parameter of Weibull baseline hazard from the pilot data.}
\item{beta}{the estimated treatment effect from the pilot data.}
\item{tau2}{the estimated inter-PDX variance from the pilot data.}
\item{sigma2}{the estimated random error variance from the pilot data.}
\item{PowTab}{the estimates of statistical power across \code{n} and \code{m}.}
}
\description{
A function to obtain a power table with the combination of
various number of PDX lines and number of individuals per PDX lines per treatment based on a preliminary dataset
}
\examples{
\donttest{
require(PDXpower)
data(animals2)
PowTab <- PowFrailtyDat(data = animals2, formula = Surv(Y,status) ~ Tx + cluster(ID),
n = 3, m = 2, ncores = 1)
PowTab
plotpower(PowTab[[5]], ylim = c(0, 1))
}

}
