% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ob_check_distincts.R
\name{ob_check_distincts}
\alias{ob_check_distincts}
\title{Check Distinct Length}
\usage{
ob_check_distincts(x, target)
}
\arguments{
\item{x}{Vector (numeric, character, or factor) whose unique values are to be counted.
Accepts any R vector type that can be compared for equality.}

\item{target}{Integer vector of binary target values (0/1). Must have the same
length as \code{x}. While not used in the distinct count calculation, it is
required for interface consistency and may be used for future extensions
(e.g., counting distinct values per class).}
}
\value{
Integer scalar representing the number of unique values in \code{x},
  excluding \code{NA} values. Returns 0 if \code{x} is empty or contains only
  \code{NA} values.
}
\description{
Internal utility function that counts the number of distinct (unique) values
in a feature vector. Used for preprocessing validation before applying optimal
binning algorithms to determine if the feature has sufficient variability.
}
\details{
This function is typically used internally by optimal binning algorithms to:
\itemize{
  \item Validate that the feature has at least 2 distinct values (required for binning).
  \item Determine if special handling is needed for low-cardinality features
    (e.g., \eqn{\le 2} unique values).
  \item Decide between binning strategies (continuous vs categorical).
}

\strong{Handling of Missing Values}:
\code{NA}, \code{NaN}, and \code{Inf} values are excluded from the count.
To include missing values as a distinct category, preprocess \code{x} by
converting missings to a placeholder (e.g., \code{"-999"} for numeric,
\code{"Missing"} for character).
}
\examples{
\donttest{
# Continuous feature with many unique values
x_continuous <- rnorm(1000)
target <- sample(0:1, 1000, replace = TRUE)
ob_check_distincts(x_continuous, target)
# Returns: ~1000 (approximately all unique due to floating point)

# Low-cardinality feature
x_binary <- sample(c("Yes", "No"), 1000, replace = TRUE)
ob_check_distincts(x_binary, target)
# Returns: 2

# Feature with missing values
x_with_na <- c(1, 2, NA, 2, 3, NA, 1)
target_short <- c(1, 0, 1, 0, 1, 0, 1)
ob_check_distincts(x_with_na, target_short)
# Returns: 3 (counts: 1, 2, 3; NAs excluded)

# Empty or all-NA feature
x_empty <- rep(NA, 100)
ob_check_distincts(x_empty, sample(0:1, 100, replace = TRUE))
# Returns: 0
}

}
\keyword{internal}
