% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subcascades.R
\name{mergeSubcascades}
\alias{mergeSubcascades}
\title{Merge Subcascades}
\usage{
mergeSubcascades(subcascades1 = NULL, subcascades2 = NULL)
}
\arguments{
\item{subcascades1}{A Subcascades object as it is returned by \code{\link{subcascades}}-function.
The Subcascades object is made up of a list of matrices. 
Each matrix comprises the evaluation results of cascades of a specific length. 
The rownames show the class order and the entries the sensitivity for each position of the cascade.}

\item{subcascades2}{A Subcascades object like subcascades1}
}
\value{
A Subcascades object comprising the evaluated cascades and their performances. 
The Subcascades object is made up of a list of matrices. 
Each matrix comprises the evaluation results of cascades of a specific length and 
is sorted row-wise according to the achieved minimal classwise sensitivities of the cascades (decreasing).
The rownames show the class order by a character string of type '1>2>3' and the entries the sensitivity for each position of the cascade.
}
\description{
\code{mergeSubcascades} adds the cascades from subcascades2 to the subcascades1, that have not been part of subcascades1.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

# make two Subcascades objects
subc1 = subcascades(predMap, size = c(3,4), thresh = 0.6)
subc2 = subcascades(predMap, size = c(4), thresh = 0.5)
# add the cascades of subcascades2 to subcascades1
mergeSubcascades(subc1, subc2)
}
