% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odmeans_graph.R
\name{odmeans_graph}
\alias{odmeans_graph}
\title{Graph ODMeans Function}
\usage{
odmeans_graph(
  odmeans_data,
  title = "ODMeans Graph",
  maptype = "roadmap",
  zoom = 4,
  add_cluster = TRUE
)
}
\arguments{
\item{odmeans_data}{It receives an object from S3 ODMeans class. However, it can also work with objects from similar classes like S3 k-Means}

\item{title}{It receives an string, and corresponds to the title of the plot.}

\item{maptype}{It receives a string with the type of the map. Depending on the map selected, it will change the background of it. The possible values are: “terrain”, “satellite”, “roadmap”, “hybrid”.}

\item{zoom}{An integer from 3 (continent) to 21 (building), which controls the level of zoom applied to the map.}

\item{add_cluster}{Receives TRUE or FALSE value. When True, it adds the number of the cluster to the arrows.}
}
\value{
A ggplot graph showing a map with the centers of the clusters.
}
\description{
Graph ODMeans Function
}
\examples{
data(ODMeansTaxiData)
odmeans_data = odmeans(ODMeansTaxiData, 10, 300, 1000, 2200, 3, 50, 100)
odmeans_plot = odmeans_graph(odmeans_data, "ODMeans Taxi Graph", "roadmap", 11, FALSE)

}
