% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kstepmalgorithm.R
\name{find_critical_value}
\alias{find_critical_value}
\title{Find Critical Value}
\usage{
find_critical_value(ecdf_func, alpha)
}
\arguments{
\item{ecdf_func}{An ECDF function representing the distribution of a random variable.}

\item{alpha}{A numeric value specifying the significance level.}
}
\value{
The smallest x such that P(X <= x) >= 1 - alpha.
}
\description{
This function finds the smallest x such that the probability of a random variable
being less than or equal to x is greater than or equal to 1 - alpha.
It uses the uniroot function to find where the empirical cumulative distribution function (ECDF)
crosses 1 - alpha.
}
\examples{
data <- rnorm(100)
ecdf_data <- ecdf(data)
critical_val <- find_critical_value(ecdf_data, 0.05)
}
