% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eblupFH1.R
\name{eblupFH1}
\alias{eblupFH1}
\title{EBLUP under stationary Fay-Herriot model for sample area}
\usage{
eblupFH1(formula, vardir, method = "REML", MAXITER, PRECISION, data)
}
\arguments{
\item{formula}{an object of class list of formula, describe the model to be fitted}

\item{vardir}{a vector of sampling variances of direct estimators for each small area}

\item{method}{type of fitting method, default is "REML" method}

\item{MAXITER}{number of iterations allowed in the algorithm. Default is 100 iterations}

\item{PRECISION}{convergence tolerance limit for the Fisher-scoring algorithm. Default value is 1e-04}

\item{data}{a data frame comprising the variables named in formula and vardir}
}
\value{
The function returns a list with the following objects:
\describe{
  \item{eblup}{a vector with the values of the estimators for each small area}
  \item{mse}{a vector of the mean squared error estimates for each small area}
  \item{sample}{a matrix consist of area code, eblup, mse, standard error (SE) and coefficient of variation (CV)}
  \item{fit}{a list containing the following objects:}
  \itemize{
    \item estcoef : a data frame with the estimated model coefficients in the first column (beta),
        their asymptotic standard errors in the second column (std.error), the t statistics in
        the third column (tvalue) and the p-values of the significance of each coefficient in
        last column (pvalue)
    \item refvar : estimated random effects variance
    \item goodness : goodness of fit statistics
    \item randomeffect : a data frame with the values of the random effect estimators
  }
 }
}
\description{
This function gives the EBLUP and the estimate of mean squared error (mse)
   based on a stationary Fay-Herriot model for sample area.
}
\examples{
# Load data set
data(paddysample)
# Fit Fay-Herriot model using sample part of paddy data
result <- eblupFH1(y ~ x1+x2, var, "REML", 100, 1e-04,paddysample)
result
}
