% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NORMA.R
\name{linear_kernel}
\alias{gaussian_kernel}
\alias{linear_kernel}
\title{Kernels}
\usage{
linear_kernel(x, y, gamma = 0)

gaussian_kernel(x, y, gamma)
}
\arguments{
\item{x}{\code{numeric} vector indicating value of \eqn{x}.}

\item{y}{\code{numeric} vector indicating value of \eqn{y}.}

\item{gamma}{gaussian kernel parameter \eqn{\gamma}.}
}
\value{
Returns a \code{numeric} representing the kernel value.
}
\description{
\code{linear_kernel} computes the linear kernel between two given vector, \eqn{x} and \eqn{y}.

\code{gaussian_kernel} computes the gaussian kernel between two given vectors, \eqn{x} and \eqn{y}.
}
\details{
Linear kernel: \deqn{k(x,y) = x*y}

Gaussian kernel: \deqn{k(x,y) = exp(-\gamma||x-y||^2)}
}
\examples{
# Linear kernel value between point x=c(1,2,3) and point y=c(2,3,4).
linear_kernel(c(1,2,3),c(2,3,4))

# Gaussian kernel value between point x=c(1,2,3) and point y=c(2,3,4) with gamma=0.1.
gaussian_kernel(c(1,2,3),c(2,3,4),0.1)
}
\author{
Jesus Prada, \email{jesus.prada@estudiante.uam.es}
}

