% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_best_nr_cluster.R
\name{find_best_nr_cluster}
\alias{find_best_nr_cluster}
\title{Finds the best number of clusters according to silhouette}
\usage{
find_best_nr_cluster(
  data,
  sim,
  method_reconstruction = "kmedoids",
  method_evaluation = "silhouette",
  report = FALSE,
  parallel = FALSE,
  best = max,
  return_all = FALSE,
  ...
)
}
\arguments{
\item{data}{The barcode data in a matrix.}

\item{sim}{A similarity matrix.}

\item{method_reconstruction}{The clustering method to use.}

\item{method_evaluation}{The evaluation method to use.}

\item{report}{Whether the current progress should be reported. Note that
this will not work if parallel is set to TRUE.}

\item{parallel}{Whether the clustering should be performed in parallel.}

\item{best}{The method to use to determine the best clustering.}

\item{return_all}{Whether to return the silhouette score for all
clusterings.}

\item{...}{passed params to evaluating clustering}
}
\value{
The R^2 value for rows is1 and is2 in matrix dat
}
\description{
Finds the best number of clusters according to silhouette
}
