% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-handling.R
\name{fac_dispatcher}
\alias{fac_dispatcher}
\title{Brew and serve fac from Momocs object}
\usage{
fac_dispatcher(x, fac)
}
\arguments{
\item{x}{a Momocs object (any \code{Coo}, \code{Coe}, \code{PCA}, etc.)}

\item{fac}{a specification to extract from \code{fac}}
}
\value{
a prepared \code{factor} (or a \code{numeric}). See examples
}
\description{
Ease various specifications for fac specification
when passed to Momocs objects. Intensively used (internally).
}
\details{
\code{fac} can be:
\itemize{
\item a factor, passed on the fly
\item a column id from \code{$fac}
\item a column name from \code{fac}
\item a formula (preferred) in the form: \code{~column_name} (from \code{$fac}, no quotes)
}
}
\examples{

bot <- mutate(bot, s=rnorm(40), fake=factor(rep(letters[1:4], 10)))

# factor, on the fly
fac_dispatcher(bot, factor(rep(letters[1:4], 10)))

# column id
fac_dispatcher(bot, 1)

# column name
fac_dispatcher(bot, "type")
# same, numeric case
fac_dispatcher(bot, "s")

# formula interface
fac_dispatcher(bot, ~type)

# formula interface + interaction on the fly
fac_dispatcher(bot, ~type+fake)
}
\seealso{
Other handling functions: \code{\link{arrange}},
  \code{\link{at_least}}, \code{\link{chop}},
  \code{\link{combine}}, \code{\link{dissolve}},
  \code{\link{filter}}, \code{\link{mutate}},
  \code{\link{rescale}}, \code{\link{rm_harm}},
  \code{\link{rm_uncomplete}}, \code{\link{rw_fac}},
  \code{\link{sample_frac}}, \code{\link{sample_n}},
  \code{\link{select}}, \code{\link{slice}}
}
