% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_angle_edge1}
\alias{coo_angle_edge1}
\alias{coo_theta3}
\title{Calculate the angle formed by three (x; y) coordinates}
\usage{
coo_angle_edge1(coo, method = c("atan2", "acos")[1])

coo_theta3(coo, method = c("atan2", "acos")[1])
}
\arguments{
\item{coo}{a 3x2 \code{matrix} of 3 points (rows) and (x; y) coordinates}

\item{method}{one of 'atan2' or 'acos' for a signed or not angle.}
}
\value{
\code{numeric} the angle in radians.
}
\description{
Returns the angle (in radians) defined by a triplet of points
either signed ('atan2') or not ('acos').
}
\note{
\code{coo_theta3} is deprecated and will be removed
in future releases.
}
\examples{
b <- coo_sample(bot[1], 64)
b <- b[c(1, 14, 24), ]
coo_plot(b)
coo_angle_edges(b)
coo_angle_edges(bot[1])
}
\seealso{
Other coo_ descriptors: \code{\link{coo_angle_edges}},
  \code{\link{coo_angle_tangent}}, \code{\link{coo_area}},
  \code{\link{coo_boundingbox}}, \code{\link{coo_chull}},
  \code{\link{coo_circularity}},
  \code{\link{coo_convexity}},
  \code{\link{coo_eccentricity}},
  \code{\link{coo_elongation}}, \code{\link{coo_length}},
  \code{\link{coo_lw}}, \code{\link{coo_rectangularity}},
  \code{\link{coo_rectilinearity}},
  \code{\link{coo_solidity}}, \code{\link{coo_width}}
}
