% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-import.R
\name{chc2pix}
\alias{chc2pix}
\title{Converts chain-coded coordinates to (x; y) coordinates}
\usage{
chc2pix(chc)
}
\arguments{
\item{chc}{a vector of chain-coded coordinates}
}
\description{
May be useful to convert chain-coded coordinates
to (x; y) coordinates. The first point is set at the origin. \link{chc2Out}
does the job for an entire dataset produced by Shape/ChainCoder, etc.
}
\examples{
data(shapes)
x <- pix2chc(shapes[1])
coo_plot(chc2pix(x))
}
\references{
Kuhl, F. P., & Giardina, C. R. (1982).
Elliptic Fourier features of a closed contour.
\emph{Computer Graphics and Image Processing}, 18(3), 236-258.
}
\seealso{
\link{pix2chc}, \link{chc2Out}

Other babel functions: \code{\link{bind_db}},
  \code{\link{chc2Out}},
  \code{\link{import_StereoMorph_curve1}},
  \code{\link{import_jpg}}, \code{\link{import_tps}},
  \code{\link{nef2Coe}}, \code{\link{ntsrow2Coo}},
  \code{\link{pix2chc}}, \code{\link{tie_jpg_txt}},
  \code{\link{tps2coo}}
}
