% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-polynomials.R
\name{opoly_i}
\alias{npoly_i}
\alias{opoly_i}
\title{Calculates shape from a polynomial model}
\usage{
opoly_i(pol, nb.pts = 120, reregister = TRUE)

npoly_i(pol, nb.pts = 120, reregister = TRUE)
}
\arguments{
\item{pol}{a pol list such as created by \link{npoly} or \link{opoly}}

\item{nb.pts}{the number of points to predict. By default (and cannot be higher)
the number of points in the original shape.}

\item{reregister}{logical whether to reregister the shape with the original baseline.}
}
\value{
a matrix of (x; y) coordinates.
}
\description{
Returns a matrix of (x; y) coordinates when passed with a list obtained with
\link{opoly} or \link{npoly}.
}
\examples{
data(olea)
o <- olea[5]
coo_plot(o)
for (i in 2:7){
x <- opoly_i(opoly(o, i))
coo_draw(x, border=col_summer(7)[i], points=FALSE)  }
}
\seealso{
Other polynomials: \code{\link{npoly}}, \code{\link{opoly}}
}

