% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_length}
\alias{coo_length}
\title{Calculates the length of a shape}
\usage{
coo_length(coo)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or a Coo object}
}
\value{
the length (in pixels) of the shape
}
\description{
Nothing more than \code{coo_lw(coo)[1]}.
}
\details{
This function can be used to integrate size - if meaningful -
to Coo objects. See also \link{coo_centsize} and \link{rescale}.
}
\examples{
data(bot)
coo_length(bot[1])
coo_length(bot)
mutate(bot, size=coo_length(bot))
}
\seealso{
\link{coo_lw}, \link{coo_width}

Other coo_ descriptors: \code{\link{coo_area}},
  \code{\link{coo_chull}},
  \code{\link{coo_circularityharalick}},
  \code{\link{coo_circularitynorm}},
  \code{\link{coo_circularity}},
  \code{\link{coo_convexity}},
  \code{\link{coo_eccentricityboundingbox}},
  \code{\link{coo_eccentricityeigen}},
  \code{\link{coo_elongation}}, \code{\link{coo_lw}},
  \code{\link{coo_rectangularity}},
  \code{\link{coo_rectilinearity}},
  \code{\link{coo_solidity}}, \code{\link{coo_tangle}},
  \code{\link{coo_theta3}}, \code{\link{coo_thetapts}},
  \code{\link{coo_width}}
}

