% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-opn-bezier.R
\name{bezier_i}
\alias{bezier_i}
\title{Calculates a shape from Bezier coefficients}
\usage{
bezier_i(B, nb.pts = 120)
}
\arguments{
\item{B}{a matrix of Bezier vertices, such as those produced by \link{bezier}}

\item{nb.pts}{the number of points to sample along the curve.}
}
\value{
a matrix of (x; y) coordinates
}
\description{
Calculates a shape from Bezier coefficients
}
\note{
Directly borrowed for Claude (2008), and called \code{beziercurve} there.
Not implemented for open outlines but may be useful for other purposes.
}
\examples{
set.seed(34)
x <- coo_sample(efourier_shape(), 5)
plot(x, ylim=c(-3, 3), asp=1, type='b', pch=20)
b <- bezier(x)
bi <- bezier_i(b$B)
lines(bi, col='red')
}
\references{
Claude, J. (2008) \emph{Morphometrics with R}, Use R! series,
Springer 316 pp.
}
\seealso{
Other bezier functions: \code{\link{bezier}}
}

