% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_jitter}
\alias{coo_jitter}
\title{Jitters shapes}
\usage{
coo_jitter(coo, ...)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates or a \code{list}, or any \link{Coo} object.}

\item{...}{additional parameter for \link{jitter}}
}
\value{
a \code{matrix} of (x; y) coordinates or a Coo object
}
\description{
A simple wrapper around \link{jitter}.
}
\examples{
b <-bot[1]
coo_plot(b, zoom=0.2)
coo_draw(coo_jitter(b, amount=3), border="red")

# for a Coo example, see \\link{get_pairs}
}
\seealso{
\link{get_pairs}

Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_calliper}}, \code{\link{coo_centdist}},
  \code{\link{coo_center}}, \code{\link{coo_centpos}},
  \code{\link{coo_centsize}}, \code{\link{coo_close}},
  \code{\link{coo_down}}, \code{\link{coo_dxy}},
  \code{\link{coo_extract}}, \code{\link{coo_flipx}},
  \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}}, \code{\link{coo_left}},
  \code{\link{coo_nb}}, \code{\link{coo_perimcum}},
  \code{\link{coo_perimpts}}, \code{\link{coo_perim}},
  \code{\link{coo_rev}}, \code{\link{coo_right}},
  \code{\link{coo_rotatecenter}}, \code{\link{coo_rotate}},
  \code{\link{coo_samplerr}}, \code{\link{coo_sample}},
  \code{\link{coo_scalex}}, \code{\link{coo_scale}},
  \code{\link{coo_shearx}}, \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_closed}}
}

