% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{predict.MoE_expert}
\alias{predict.MoE_expert}
\alias{fitted.MoE_expert}
\alias{residuals.MoE_expert}
\title{Predictions from MoEClust expert networks}
\usage{
\method{predict}{MoE_expert}(object,
        newdata = NULL,
        simplify = FALSE,
        droplevels = FALSE,
        ...)

\method{fitted}{MoE_expert}(object,
       ...)

\method{residuals}{MoE_expert}(object,
          ...)
}
\arguments{
\item{object}{An object of class \code{"MoE_expert"} (typically \code{x$expert}, where \code{x} is of class \code{"MoEClust"}).}

\item{newdata}{A matrix or data frame of test examples. If omitted, the fitted values are used.}

\item{simplify}{Logical indicating whether to simplify the output (in the form of a list) to a 3-dimensional array with dimensions given by the number of new observations, the number of variables, and the number of clusters. The first dimension of such an array is of length \code{1} when there are no expert network covariates, in which case the entries correspond to \code{object$parameters$mean}. Defaults to \code{FALSE}.}

\item{droplevels}{A logical indicating whether unseen factor levels in categorical variables within \code{newdata} should be dropped (with \code{NA} predicted in their place). Defaults to \code{FALSE}. See \code{\link{drop_levels}}.}

\item{...}{Catches unused arguments or allows the \code{simplify} argument to be passed through \code{fitted} and \code{residuals}.}
}
\value{
For \code{simplify=FALSE}, either a list of vectors or predictions (for univariate data) or a list of matrices of predictions (for multivariate data). These lists are of the same length as number of non-noise components in the fitted model. When \code{simplify=TRUE}, a 3-dimensional array of predictions is returned, with respective dimensions given by the number of observations, variables, and non-noise components.
}
\description{
Predictions (point estimates) of observation-specific component means from each (non-noise) component's expert network linear regression.
}
\details{
This function is effectively just a shortcut to \code{lapply(x$expert, predict.lm, newdata=...)}. It can also be thought of as a wrapper to \code{\link{predict.MoEClust}(x, ...)$mean}, although it returns a list (by default) rather than a 3-dimensional array and also \emph{always} preserves the dimensions of \code{newdata}, even for models without expert network covariates.
}
\examples{
data(CO2data)
res <- MoE_clust(CO2data$CO2, G=3, equalPro=TRUE, expert= ~ GNP, network.data=CO2data)
predict(res$expert)

# Try with newdata and simplify=TRUE
predict(res$expert, newdata=CO2data[1:5,"GNP", drop=FALSE], simplify=TRUE)
}
\seealso{
\code{\link{predict.MoEClust}}, \code{\link[stats]{lm}}, \code{\link{predict.MoE_gating}}, \code{\link{drop_levels}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{prediction}
\keyword{utility}
