% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.dendrogram.trait.R
\name{get.dendrogram.trait}
\alias{get.dendrogram.trait}
\title{Dendrogram}
\usage{
get.dendrogram.trait(
  population,
  path = NULL,
  database = NULL,
  gen = NULL,
  cohorts = NULL,
  traits = NULL,
  type = "pheno"
)
}
\arguments{
\item{population}{Population list}

\item{path}{provide a path if the dendrogram would be saved as a png-file}

\item{database}{Groups of individuals to consider}

\item{gen}{Quick-insert for database (vector of all generations to consider)}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to consider)}

\item{traits}{Traits to include in the dendrogram (default: all traits)}

\item{type}{Which traits values to consider (default: "pheno", alt: "bv", "bve")}
}
\value{
Dendrogram plot for traits
}
\description{
Function calculate a dendogram for the traits
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=100, n.additive = c(100,100,100),
               shuffle.cor = matrix(c(1,0.8,0.2,0.8,1,0.2,0.2,0.2,1), ncol=3), shuffle.traits = 1:3)
population <- breeding.diploid(population, phenotyping = "all", heritability = 0.5)
get.dendrogram.trait(population, gen=1, type="pheno")
}
