% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sampleOriginPos}
\alias{sampleOriginPos}
\alias{sampleOriginDist}
\alias{sampleTargetPos}
\alias{sampleTargetDist}
\title{Example origin and target site positions and distances on a 2-D plane}
\format{
Each dataset is a named list with 12 matrices in it, representing 12
scenarios. The position matrices each have 2 columns (x and y position) and
4 rows (for each origin or target site).  The distance matrices are
symmetrical and 4 x 4. The 12 scenarios are:
\itemize{
  \item Linear: Both origin and target sites arranged in horizontal linear
     fashion, with equal distances between each adjacent site
  \item B Dist BC*2: Linear, but the central origin sites are twice as far
     from each other as the edge sites are from the adjacent origin sites
  \item B Dist BC/2: Linear, but the central origin sites are half as far
     from each other as the edge sites are from the adjacent origin sites
  \item B Dist CD*2: Linear, but the last two origin sites are twice as far
     from each other as the other adjacent origin sites
  \item B Dist CD/2: Linear, but the last two origin sites are half as far
     from each other as the other adjacent origin sites
  \item B Grid: Origin sites arranged on a grid, target sites arranged
     linearly, both with all adjacent sites (excluding diagonals)
     equidistant
  \item NB Dist 23*2: Linear, but the central target sites are twice as far
     from each other as the edge sites are from the adjacent target sites
  \item NB Dist 23/2: Linear, but the central target sites are half as far
     from each other as the edge sites are from the adjacent target sites
  \item NB Dist 34*2: Linear, but the last two target sites are twice as far
     from each other as the other adjacent target sites
  \item NB Dist 34/2: Linear, but the last two target sites are half as far
     from each other as the other adjacent target sites
  \item NB Grid: Target sites arranged on a grid, origin sites arranged
     linearly, both with all adjacent sites (excluding diagonals)
     equidistant
  \item B/NB Grid: Origin and target sites each arranged on a grid, both
     with all adjacent sites (excluding diagonals) equidistant
}

An object of class \code{list} of length 12.

An object of class \code{list} of length 12.

An object of class \code{list} of length 12.
}
\usage{
sampleOriginPos

sampleOriginDist

sampleTargetPos

sampleTargetDist
}
\description{
\code{sampleOriginPos} is a dataset containing example origin site positions
from 12 scenarios used in Cohen et al. (2018).  For the same 12
scenarios, \code{sampleOriginDist} contains the origin site distances,
\code{sampleTargetPos} contains the target site positions, and
\code{sampleTargetDist} contains the target site distances.
}
\keyword{datasets}
