% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_comps.R
\name{case_weights}
\alias{case_weights}
\title{Extract Case Weights}
\usage{
case_weights(object, newdata = NULL)
}
\arguments{
\item{object}{model \link{fit} result, \code{\link{ModelFrame}}, or
\code{\link[recipes]{recipe}}.}

\item{newdata}{dataset from which to extract the weights if given; otherwise,
\code{object} is used.  The dataset should be given as a \code{ModelFrame}
or as a \link[=data.frame]{data frame} if \code{object} contains a
\code{ModelFrame} or a \code{recipe}, respectively.}
}
\description{
Extract the case weights from an object.
}
\examples{
## Training and test sets
inds <- sample(nrow(ICHomes), nrow(ICHomes) * 2 / 3)
trainset <- ICHomes[inds, ]
testset <- ICHomes[-inds, ]

## ModelFrame case weights
trainmf <- ModelFrame(sale_amount ~ . - built, data = trainset, weights = built)
testmf <- ModelFrame(formula(trainmf), data = testset, weights = built)
mf_fit <- fit(trainmf, model = GLMModel)
rmse(response(mf_fit, testmf), predict(mf_fit, testmf),
     case_weights(mf_fit, testmf))

## Recipe case weights
library(recipes)
rec <- recipe(sale_amount ~ ., data = trainset) \%>\%
  role_case(weight = built, replace = TRUE)
rec_fit <- fit(rec, model = GLMModel)
rmse(response(rec_fit, testset), predict(rec_fit, testset),
     case_weights(rec_fit, testset))

}
