% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bcov.R
\name{Bcov}
\alias{Bcov}
\title{Bartlett's Test for One Sample Covariance Matrix}
\usage{
Bcov(data, Sigma)
}
\arguments{
\item{data}{a data frame.}

\item{Sigma}{The covariance matrix in NULL hypothesis.}
}
\value{
a list with 3 elements:
\item{ChiSquare}{The value of Test Statistic}
\item{df}{The Chi-Square statistic's degree of freedom}
\item{p.value}{p value}
}
\description{
\code{Bcov} function tests whether the covariance matrix is equal to a 
given matrix or not.
}
\details{
This function computes  Bartlett's test statistic for the covariance 
matrix of one sample.
}
\examples{

data(iris) 
S<-matrix(c(5.71,-0.8,-0.6,-0.5,-0.8,4.09,-0.74,-0.54,-0.6,
     -0.74,7.38,-0.18,-0.5,-0.54,-0.18,8.33),ncol=4,nrow=4)
result <- Bcov(data=iris[,1:4],Sigma=S)
summary(result)
}
\references{
Rencher, A. C. (2003). Methods of multivariate analysis 
(Vol. 492). John Wiley & Sons.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
