% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_general.R
\name{mcee_general}
\alias{mcee_general}
\title{Mediated Causal Excursion Effects (configurable nuisance models)}
\usage{
mcee_general(
  data,
  id,
  dp,
  outcome,
  treatment,
  mediator,
  availability = NULL,
  time_varying_effect_form,
  config_p,
  config_q,
  config_eta,
  config_mu,
  config_nu,
  weight_per_row = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{A data.frame in long format (one row per id-by-decision point).}

\item{id}{Character. Column name for subject identifier.}

\item{dp}{Character. Column name for decision point index (must increase strictly within subject).}

\item{outcome}{Character. Column name for distal outcome (constant within subject).}

\item{treatment}{Character. Column name for treatment (coded 0/1).}

\item{mediator}{Character. Column name for mediator.}

\item{availability}{Optional character. Column name for availability (0/1). If \code{NULL}, all rows are treated as available.}

\item{time_varying_effect_form}{RHS-only formula for the basis \eqn{f(t)} (e.g., \code{~ 1}, \code{~ dp}, \code{~ poly(dp,2)}).}

\item{config_p, config_q, config_eta, config_mu, config_nu}{Lists created by
\code{mcee_config_maker()} or helpers (e.g., \code{mcee_config_glm()},
\code{mcee_config_known()}, \code{mcee_config_ranger()}, etc.).}

\item{weight_per_row}{Optional numeric vector of row weights (nonnegative, length \code{nrow(data)}). If \code{NULL}, uniform within-id weights are used.}

\item{verbose}{Logical; print progress messages.}
}
\value{
An \code{"mcee_fit"} object; see \code{\link{mcee}}.
}
\description{
Like \code{\link{mcee}}, but each nuisance function is configured explicitly
via \code{config_*} objects (formula/method/family or known).
}
\details{
Use this wrapper for observational studies (estimate \code{p}) or when you want
different learners per nuisance. The same data requirements as \code{\link{mcee}} apply.
}
\examples{
set.seed(1)
n <- 10
T <- 4
id <- rep(1:n, each = T)
dp <- rep(1:T, times = n)
A <- rbinom(n * T, 1, 0.5)
M <- rbinom(n * T, 1, plogis(-0.2 + 0.3 * A + 0.1 * dp))
Y <- ave(0.5 * A + 0.6 * M + 0.1 * dp + rnorm(n * T), id)
dat <- data.frame(id, dp, A, M, Y)

cfg <- list(
    p   = mcee_config_known("p", 0.5),
    q   = mcee_config_glm("q", ~ dp + M),
    eta = mcee_config_glm("eta", ~dp),
    mu  = mcee_config_glm("mu", ~ dp + M),
    nu  = mcee_config_glm("nu", ~dp)
)
fit_gen <- mcee_general(dat, "id","dp","Y","A","M",
    time_varying_effect_form = ~ dp,
    config_p=cfg$p, config_q=cfg$q, config_eta=cfg$eta, config_mu=cfg$mu, config_nu=cfg$nu)
}
\seealso{
\code{\link{mcee}}, \code{\link{mcee_userfit_nuisance}}, \code{\link{mcee_config_maker}}
}
