% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_process.R
\name{calc_ML}
\alias{calc_ML}
\title{Calculate mean lengths >= Lc}
\usage{
calc_ML(MLZ_data, length.slot = c("Len_df", "Len_matrix"),
  sample.size = TRUE)
}
\arguments{
\item{MLZ_data}{An object of class \code{\linkS4class{MLZ_data}}.}

\item{length.slot}{Name of slot in \code{\linkS4class{MLZ_data}} from which to calculate
mean lengths, either: \code{Len_df} or \code{Len_matrix}. Only used if there are data in both slots.}

\item{sample.size}{If \code{TRUE}, then the annual sample sizes will be calculated by
summing the cells in slot \code{Len_matrix}. Otherwise, sample sizes are set to 0 or 1
(whether mean lengths are calculated).}
}
\value{
An object of class \code{\linkS4class{MLZ_data}} to fill slots \code{MeanLength}, \code{ss}.
}
\description{
Calculates mean lengths from length data and Lc for class \code{\linkS4class{MLZ_data}}.
}
\examples{
data(Nephrops)
Nephrops <- calc_ML(Nephrops, sample.size = FALSE)
Nephrops@MeanLength
plot(Nephrops)
}
