% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf.R
\name{bflt}
\alias{bflt}
\title{Compute BF(Less than)}
\usage{
bflt(mcmc, less_than, prior_cumul_fun, ...)
}
\arguments{
\item{mcmc}{MCMC vector.}

\item{less_than}{Value to test.}

\item{prior_cumul_fun}{CDF function.}

\item{...}{}
}
\value{
BF12 value.
}
\description{
Computes the BF12, where 1 is less than and 2 is greater than.
}
\details{
The BF12 here is BF for a parameter being less than a threshold, t, vs the parameter being greater than t.
This borrows from the encompassing approach, where u is the unconstrained prior:
BF1u = p(D|H = 1) / p(D|H = u)
BF2u = p(D|H = 2) / p(D|H = u)
BF12 = BF1u / BF2u.

BF1u = int p(D|H = 1, theta_1)p(theta_1 | H = 1) / p(D|H = u, theta_u)p(theta_u | H=u)
}
\author{
Stephen Martin
}
\keyword{internal}
