% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mskAll.R
\name{mskall}
\alias{mskall}
\title{Mean score method for missing covariate value in linear regression model for repeated measurement data}
\usage{
mskall(cvstr = "unstructured", Dep, Id, Time, m, n, data)
}
\arguments{
\item{cvstr}{"unstuctured","compound","ToE","AR1","markov","independence"}

\item{Dep}{column name of dependent variable in the dataset}

\item{Id}{column name of id of subjects in the dataset}

\item{Time}{column name of timepoints in the dataset}

\item{m}{starting column number of covariates}

\item{n}{ending column number of covariates}

\item{data}{balanced longitudinal data set where each subject's outcome has been measured at same time points and
number of visits for each patient is samiliar covariance structure}
}
\value{
estimated parameter value for multiple linear regression model
}
\description{
provides estimates of parameter from linear regression model using meanscore method for repeated measurement data.
}
\details{
Mean score method is used for getting the missing score function value in the estimating
equation.
}
\examples{
data(srdata)
mskall(cvstr="ToE",Dep="C6kine",Id="ID",Time="Visit",m=5,n=10,data=srdata)
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
