% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Generate Volcano plot base on Deseq_analysis or indicator_analysis results}
\usage{
volcano_plot(inputframe, cutoff = NULL, aes_col = c("#FE5C5C", "#75ABDE"))
}
\arguments{
\item{inputframe}{A data frame containing the results based on \code{\link{Deseq_analysis}} or \code{\link{indicator_analysis}} (only two group indicators)}

\item{cutoff}{A numeric value specifying the fold change cutoff,should be the same as in \code{\link{Deseq_analysis}}}

\item{aes_col}{A named vector of colors to be used in the plots}
}
\value{
A list of two ggplot objects, one for the fold change versus adjusted p-value plot and
another for the mean abundance versus fold change or enrichment factor plot.
}
\description{
Generate Volcano plot base on Deseq_analysis or indicator_analysis results
}
\examples{
###data prepration###
\donttest{
{
  # Load data
  data("Two_group")

  # Define color based on treatment column
  mycolor <- Two_group$configuration$treat_col

  ### DESeq analysis ###
  deseq_results <- Deseq_analysis(
    taxobj = Two_group,
    taxlevel = "Genus",
    cutoff = 1,
    control_name = "Control"
  )

  ### Or indicator analysis ###
  indicator_results <- indicator_analysis(
    taxobj = Two_group,
    taxlevel = "Genus"
  )

  # Create volcano plot for DESeq results
  volcano_plot <- volcano_plot(
    inputframe = deseq_results,
    cutoff = 1,
    aes_col = mycolor
  )
  print(volcano_plot$FC_FDR)  # Fold Change and FDR values
  print(volcano_plot$Mean_FC)  # Mean Fold Change values

  # Create volcano plot for indicator results
  volcano_plot <- volcano_plot(
    inputframe = indicator_results,
    cutoff = 1,
    aes_col = mycolor
  )
  print(volcano_plot$FC_FDR)  # Fold Change and FDR values
  print(volcano_plot$Mean_FC)  # Mean Fold Change values
}
}
}
\author{
Wang Ningqi \href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
