% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/McCloskey_Perron.R
\name{gph}
\alias{gph}
\title{GPH estimator of fractional difference parameter d.}
\usage{
gph(X, m, l = 1)
}
\arguments{
\item{X}{vector of length T.}

\item{m}{bandwith parameter specifying the number of Fourier frequencies.
used for the estimation usually \code{floor(1+T^delta)}, where 0<delta<1.}

\item{l}{trimming parameter that determines with which Fourier frequency to start.
Default value is \code{l=1}.}
}
\description{
\code{gph} log-periodogram estimator of Geweke and Porter-Hudak (1983) (GPH) and Robinson (1995a) for memory parameter d.
}
\details{
add details here.
}
\examples{
library(fracdiff)
T<-500
m<-floor(1+T^0.8)
d=0.4
series<-fracdiff.sim(n=T, d=d)$series
gph(X=series,m=m)
}
\references{
Robinson, P. M. (1995): Log-periodogram regression of time series with 
long range dependence. The Annals of Statistics, Vol. 23, No. 5, pp. 1048 - 1072.

Geweke, J. and Porter-Hudak, S. (1983): The estimation and application 
of long memory time series models. Journal of Time Series Analysis, 4, 221-238.
}
