% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VARFIMA_est.R
\name{VARFIMA.est}
\alias{VARFIMA.est}
\title{Maximum likelihood estimation of a VARFIMA(1,1) in final equations form.}
\usage{
VARFIMA.est(data, approx = 100, split = 1, rep = FALSE)
}
\arguments{
\item{data}{data matrix with T observations of q-dimensional process.}

\item{approx}{order of the AR-approximation that is supposed to be used. Default is \code{approx=100}.}

\item{split}{to increase the speed the sample can be divided in \code{split} parts. 
Parmeter estimation is then carried out seperately for each subsample and results are averaged across the subsamples.}

\item{rep}{is passed to \code{ll_VARFIMA} and determines whether the current parameter vector is printed to the user in
every iteration of the numerical maximization procedure.}
}
\description{
\code{VARFIMA.est} returns the maximum likelihood estimate of the parameter vector of a VARFIMA(1,1) in final equations form.
}
\details{
add details here.
}
\examples{
series<-VARFIMA.sim(phi=0.4, THETA=matrix(c(0,0,0,0),2,2), 
d.vec=c(0.4,0.3), T=1000, Sigma=matrix(c(1,0.4,0.4,1),2,2))
ts.plot(series, col=1:2)
acf(series, lag=100)
VARFIMA.est(series, approx=100, rep=FALSE)
}
\references{
Lutkepohl, H. (2007): New introduction to multiple time series analysis. Springer.
}
