% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZRY18_LM.R
\name{FCI_ZRY18}
\alias{FCI_ZRY18}
\title{Rank estimation in fractionally cointegrated systems (Zhang, Robinson, Yao (2018))}
\usage{
FCI_ZRY18(X, lag_max, lag_max2 = 20, c0 = 0.3)
}
\arguments{
\item{X}{data matrix.}

\item{lag_max}{number of lags in autocovariance matrix of data for eigenvector estimation.}

\item{lag_max2}{number of residual autocorrelations that are averaged, default is \code{m=20} as recommended by Zhang, Robinson, Yao (2018).}

\item{c0}{threshold to compare averaged residual autocorrelation to, default is \code{c0=0.3} as recommended by Zhang, Robinson, Yao (2018).}
}
\description{
\code{FCI_CH06} SRank estimation in fractionally cointegrated systems (Zhang, Robinson, Yao (2018)).
 Returns estimated cointegrating rank, r=0,...,dim-1.
}
\examples{
T<-1000
series<-FI.sim(T=T, q=3, rho=0.4, d=c(0.2,0.2,1), B=rbind(c(1,0,-1),c(0,1,-1),c(0,0,1)))
FCI_ZRY18(series, lag_max=5, lag_max2=20, c0=0.3) 
series<-FI.sim(T=T, q=3, rho=0.4, d=c(1,1,1))
FCI_ZRY18(series, lag_max=5, lag_max2=20, c0=0.3) 
}
\references{
Zhang, R., Robinson, P. and Yao, Q. (2018): Identifying cointegration by eigenanalysis. Journal of the American Statistical Association (forthcoming).
}
\author{
Michelle Voges
}
