% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusteringLC.R
\name{UPSgraph}
\alias{UPSgraph}
\title{Display Sensitivity Analysis Graphic in Unsupervised Propensiy Scoring}
\usage{
UPSgraph(envir, nncol = "red", nwcol = "green3", ivcol = "blue", ...)
}
\arguments{
\item{envir}{name of the working local control classic environment.}

\item{nncol}{optional; string specifying color for display of the Mean of the LTD
distribution when weighted by cluster size from any calls to UPSnnltd().}

\item{nwcol}{optional; string specifying color for display of the Mean of the LTD
distribution when weighted inversely proportional to variance from any calls to UPSnnltd().}

\item{ivcol}{optional; string specifying color for display of the Difference in LOA
predictions, at PS = 100\% minus that at PS = 0\%, from any calls to UPSivadj().}

\item{...}{Additional arguments to pass to the plotting function.}
}
\description{
Plot summary of results from multiple calls to UPSnnltd() and/or UPSivadj() after an
 initial setup call to UPSaccum().  The UPSgraph() plot displays any sensitivity of the LTD and
 LOA Distributions to choice of Number of Clusters in X-space.
}
\details{
The third phase of Unsupervised Propensity Scoring is a graphical Sensitivity
 Analysis that depicts how the Overall Means of the LTD and LOA distributions change with
 the number of clusters.
}
\references{
\itemize{
 \item Kaufman L, Rousseeuw PJ. (1990) \bold{Finding Groups in Data.  An Introduction to
 Cluster Analysis}.  \emph{New York: John Wiley and Sons}.

 \item Obenchain RL. (2004) Unsupervised Propensity Scoring: NN and IV Plots.
 \emph{Proceedings of the American Statistical Association (on CD)} 8 pages.

 \item Obenchain RL. (2011) \bold{USPSinR.pdf}  USPS R-package vignette, 40 pages.

 \item Rubin DB. (1980) Bias reduction using Mahalanobis metric matching.
 \emph{Biometrics} \bold{36}: 293-298.
}
}
\seealso{
\code{\link{UPSnnltd}}, \code{\link{UPSivadj}} and \code{\link{UPSaccum}}.
}
\author{
Bob Obenchain <wizbob@att.net>
}
\keyword{hplot}
