% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_plots.R
\name{LoTTA_plot_effect}
\alias{LoTTA_plot_effect}
\title{LoTTA_plot_effect}
\usage{
LoTTA_plot_effect(
  LoTTA_posterior,
  nbins = 10,
  probs = c(0.025, 0.975),
  x_lab = "Cutoff location",
  y_lab1 = "Treatment effect",
  y_lab2 = "Density of cutoff location",
  title = "Cutoff location vs. Treatment effect",
  axis.text = element_text(family = "sans", size = 10),
  text = element_text(family = "serif"),
  plot.theme = theme_classic(base_size = 14),
  plot.title = element_text(hjust = 0.5),
  ...
)
}
\arguments{
\item{LoTTA_posterior}{\itemize{
\item output of one of the LoTTA functions (LoTTA_fuzzy_CONT, LoTTA_fuzzy_BIN)
with all parameters sampled (the default option in those functions)
}}

\item{nbins}{\itemize{
\item number of bins to aggregate the values of the posterior cutoff location
}}

\item{probs}{\itemize{
\item list of two quantiles that limit the range of cutoff values displayed on the plots
}}

\item{x_lab}{\itemize{
\item label of the x-axis
}}

\item{y_lab1}{\itemize{
\item label of the y-axis of the bottom plot
}}

\item{y_lab2}{\itemize{
\item label of the y-axis of the top plot
}}

\item{title}{\itemize{
\item title of the plot
}}

\item{axis.text}{\itemize{
\item can be any value that is accepted in the argument \emph{axis.text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font to a serif one axis.text=element_text(family = "sans",size = 10)
}}

\item{text}{\itemize{
\item can be any value that is accepted in the argument \emph{text} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default is changes font to a serif one text=element_text(family='serif')
}}

\item{plot.theme}{\itemize{
\item ggplot2 plot theme (see https://ggplot2.tidyverse.org/reference/ggtheme.html)
possibly with additional arguments, it takes the default value plot.theme=theme_classic(base_size = 14),
}}

\item{plot.title}{\itemize{
\item can be any value that is accepted in the argument \emph{plot.title} in the \emph{theme} function
of ggplot2 package,refer to ggplot2 manual for the possible values;
by default it centers the plot title plot.title = element_text(hjust = 0.5)
}}

\item{...}{\itemize{
\item other arguments of the \emph{theme} function, refer to ggplot2 manual
}}
}
\value{
ggplot2 object
}
\description{
Function that visualizes the impact of the cutoff location on the treatment effect estimate.
It plots too figures. The bottom figure depicts the posterior density of the cutoff location.
The top figure depicts the box plot of the treatment effect given the cutoff point.
If the prior on the cutoff location was discrete each box corresponds to a distinct cutoff point.
If the prior was continuous each box correspond to an interval of cutoff values
(the number of intervals can be changed through nbins).
}
\examples{
# functions to generate the data

ilogit <- function(x) {
  return(1 / (1 + exp(-x)))
}

fun_prob55 <- function(x) {
  P = rep(0, length(x))
  P[x >= 0.] = ilogit((8.5 * x[x >= 0.] - 1.5)) / 10.5 + 0.65 - 0.0007072
  P[x < 0.] = (x[x < 0.] + 1)^4 / 15 + 0.05
  return(P)
}

sample_prob55 <- function(x) {
  P = rep(0, length(x))
  P[x >= 0.] = ilogit((8.5 * x[x >= 0.] - 1.5)) / 10.5 + 0.65 - 0.0007072
  P[x < 0.] = (x[x < 0.] + 1)^4 / 15 + 0.05
  t = rep(0, length(x))
  for (j in 1:length(x)) {
    t[j] = sample(c(1, 0), 1, prob = c(P[j], 1 - P[j]))
  }
  return(t)
}

funB <- function(x) {
  y = x
  x2 = x[x >= 0]
  x1 = x[x < 0]
  y[x < 0] = 1 / (1 + exp(-2 * x1)) - 0.5 + 0.4
  y[x >= 0] = (log(x2 * 2 + 1) - 0.15 * x2^2) * 0.6 - 0.20 + 0.4
  return(y)
}

funB_sample <- function(x) {
  y = funB(x)+ rnorm(length(x), 0, 0.1)
  return(y)
}

## Use case example ##
\donttest{
  N=500
  x = sort(runif(N, -1, 1))
  t = sample_prob55(x)
  y = funB_sample(x)
  # comment out to try different priors:
   c_prior=list(clb=-0.25,cub=0.25) # uniform prior on the interval [-0.25,0.25]
  # c_prior=list(cstart=-0.25,cend=0.25,grid=0.05) # uniform discrete prior
  # on -0.25, -0.2, ..., 0.25
  # c_prior=0 # known cutoff c=0

  # running LoTTA model on fuzzy RDD with continuous outcomes and unknown cutoff;
  # cutoff = 0, compliance rate = 0.55, treatment effect = -0.3636364
  # remember to check convergence and adjust burnin, sample and adapt if needed
  out = LoTTA_fuzzy_CONT(x,t,y,c_prior,burnin = 10000,sample = 5000,adapt=1000)

  # print effect estimate:
  out$Effect_estimate
  # print JAGS output to asses convergence (the output is for normalized data)
  out$JAGS_output
  # plot posterior fit of the outcome function
  LoTTA_plot_outcome(out,nbins = 60)
  # plot posterior fit of the treatment probablity function
  LoTTA_plot_treatment(out,nbins = 60)
  # plot dependence of the treatment effect on the cutoff location
  LoTTA_plot_effect(out)

}
}
