% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idTGpos.R
\name{idTGpos}
\alias{idTGpos}
\title{Triacylglycerols (TG) annotation for ESI+}
\usage{
idTGpos(MS1, MSMS1, MSMS2, ppm_precursor = 5, ppm_products = 10,
  rttol = 3, rt, adducts = c("M+NH4", "M+Na"), clfrags = c(),
  clrequired = c(), ftype = c(),
  chainfrags_sn1 = c("cbdiff-dg_M+H-H2O"),
  chainfrags_sn2 = c("cbdiff-dg_M+H-H2O"),
  chainfrags_sn3 = c("cbdiff-dg_M+H-H2O"),
  intrules = c("cbdiff-dg_sn2/cbdiff-dg_sn1",
  "cbdiff-dg_sn2/cbdiff-dg_sn3", "cbdiff-dg_sn1/cbdiff-dg_sn3"),
  rates = c("1", "1", "1"), intrequired = c(T, T, T),
  coelCutoff = 0.8, dbs)
}
\arguments{
\item{MS1}{list with two data frames cointaining all peaks from the full MS
function ("peaklist" data frame) and the raw MS scans data ("rawScans" data
frame). They must have four columns: m.z, RT (in seconds), int (intensity)
and peakID (link between both data frames). "rawScans" data frame also needs
a extra column named "Scan", which indicates the scan order number. Output
of \link{dataProcessing} function. In case no coelution score needs to be
applied, this argument can be just the peaklist data frame.}

\item{MSMS1}{list with two data frames cointaining all peaks from the high
energy function ("peaklist" data frame) and the raw MS scans data ("rawScans"
data frame). They must have four columns: m.z, RT (in seconds), int (intensity)
and peakID (link between both data frames). "rawScans" data frame also needs
a extra column named "Scan", which indicates the scan order number. Output
of \link{dataProcessing} function. In case no coelution score needs to be
applied, this argument can be just the peaklist data frame.}

\item{MSMS2}{list with two data frames cointaining all peaks from a second high
energy function ("peaklist" data frame) and the raw MS scans data ("rawScans"
data frame). They must have four columns: m.z, RT (in seconds), int (intensity)
and peakID (link between both data frames). "rawScans" data frame also needs
a extra column named "Scan", which indicates the scan order number. Output
of \link{dataProcessing} function. In case no coelution score needs to be
applied, this argument can be just the peaklist data frame. Optional.}

\item{ppm_precursor}{mass tolerance for precursor ions. By default, 5 ppm.}

\item{ppm_products}{mass tolerance for product ions. By default, 10 ppm.}

\item{rttol}{total rt window for coelution between precursor and product
ions. By default, 3 seconds.}

\item{rt}{rt range where the function will look for candidates. By default,
it will search within all RT range in MS1.}

\item{adducts}{expected adducts for TG in ESI+. Adducts allowed can
be modified in adductsTable (dbs argument).}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See \link{checkClass} for details.}

\item{clrequired}{logical vector indicating if each class fragment is
required or not. If any of them is required, at least one of them must be
present within the coeluting fragments. See \link{checkClass} for details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See \link{checkClass} for details.}

\item{chainfrags_sn1}{character vector containing the fragmentation rules for
the chain fragments in sn1 position. See \link{chainFrags} for details.}

\item{chainfrags_sn2}{character vector containing the fragmentation rules for
the chain fragments in sn2 position. See \link{chainFrags} for details. If
empty, it will be estimated based on the difference between precursors and
sn1 chains.}

\item{chainfrags_sn3}{character vector containing the fragmentation rules for
the chain fragments in sn3 position. See \link{chainFrags} for details. If
empty, it will be estimated based on the difference between precursors and
sn2 chains.}

\item{intrules}{character vector specifying the fragments to compare. See
\link{checkIntensityRules}. If some intensity rules should be employed to
identify the chains position but they are't known yet, use "Unknown". If it
isn't required, leave an empty vector.}

\item{rates}{character vector with the expected rates between fragments given
as a string (i.e. "3/1"). See \link{checkIntensityRules}.}

\item{intrequired}{logical vector indicating if any of the rules is required.
If not, at least one must be verified to confirm the structure.}

\item{coelCutoff}{coelution score threshold between parent and fragment ions.
Only applied if rawData info is supplied. By default, 0.8.}

\item{dbs}{list of data bases required for annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be supplied. See \link{createLipidDB}
and \link{assignDB}.}
}
\value{
list with TG annotations (results) and some additional information
(class fragments and chain fragments).
}
\description{
TG identification based on fragmentation patterns for LC-MS/MS
AIF data acquired in positive mode.
}
\details{
\code{idTGpos} function involves 5 steps. 1) FullMS-based
identification of candidate TG as M+NH4 and M+Na. 2) Search of TG class
fragments: there are no class fragment by default. 3) Search of specific
fragments that inform about the FA chains: DGs resulting from the loss of FA
chains as M+H-H2O.  4) Look for possible chains structure based on the
combination of chain fragments. 5) Check intensity rules to confirm chains
position. In the case of TG, DG resulting from the loss of sn2 if the most
intense, followed by the loss of sn1 and sn3, but this FA position level
still needs to be improved due to the high level of coelution for TG.

Results data frame shows: ID, class of lipid, CDB (total number
of carbons and double bounds), FA composition (specific chains composition if
it has been confirmed), mz, RT (in seconds), I (intensity, which comes
directly from de input), Adducts, ppm (m.z error), confidenceLevel (Subclass,
FA level, where chains are known but not their positions, or FA position
level) and PFCS (parent-fragment coelution score mean of all fragments used
for the identification).
}
\note{
Isotopes should be removed before identification to avoid false
positives.
This function has been writen based on fragmentation patterns observed for
two different platforms (QTOF 6550 from Agilent and Sinapt G2-Si from Waters),
but it may need to be customized for other platforms or acquisition settings.
}
\examples{
\donttest{
idTGpos(MS1 = LipidMS::MS1_pos, MSMS1 = LipidMS:MSMS1_pos,
MSMS2 = LipidMS::MSMS2_pos)
}

}
\author{
M Isabel Alcoriza-Balaguer <maialba@alumni.uv.es>
}
