% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Estimate_liabilities.R
\name{estimate_liability_single}
\alias{estimate_liability_single}
\title{Estimating the genetic or full liability}
\usage{
estimate_liability_single(
  .tbl = NULL,
  family_graphs = NULL,
  h2 = 0.5,
  pid = "PID",
  fam_id = "fam_ID",
  family_graphs_col = "fam_graph",
  role = NULL,
  out = c(1),
  tol = 0.01
)
}
\arguments{
\item{.tbl}{A matrix, list or data frame that can be converted into a tibble.
Must have at least five columns that hold the family identifier, the personal
identifier, the role and the lower and upper thresholds. Note that the
role must be one of the following abbreviations
\itemize{
\item \code{g} (Genetic component of full liability)
\item \code{o} (Full liability)
\item \code{m} (Mother)
\item \code{f} (Father)
\item \code{c[0-9]*.[0-9]*} (Children)
\item \code{mgm} (Maternal grandmother)
\item \code{mgf} (Maternal grandfather)
\item \code{pgm} (Paternal grandmother)
\item \code{pgf} (Paternal grandfather)
\item \code{s[0-9]*} (Full siblings)
\item \code{mhs[0-9]*} (Half-siblings - maternal side)
\item \code{phs[0-9]*} (Half-siblings - paternal side)
\item \code{mau[0-9]*} (Aunts/Uncles - maternal side)
\item \code{pau[0-9]*} (Aunts/Uncles - paternal side).
Defaults to \code{NULL}.
}}

\item{family_graphs}{A tibble with columns pid and family_graph_col.
See prepare_graph for construction of the graphs. The family graphs Defaults to NULL.}

\item{h2}{A number representing the heritability on liability scale
for a single phenotype. Must be non-negative. Note that under the liability threshold model,
the heritability must also be at most 1.
Defaults to 0.5.}

\item{pid}{A string holding the name of the column in \code{.tbl} (or \code{family} and
\code{threshs}) that hold the personal identifier(s). Defaults to "PID".}

\item{fam_id}{A string holding the name of the column in \code{.tbl} or \code{family} that
holds the family identifier. Defaults to "fam_ID".}

\item{family_graphs_col}{Name of column with family graphs in family_graphs. Defaults to "fam_graph".}

\item{role}{A string holding the name of the column in \code{.tbl} that
holds the role. Each role must be chosen from the following list of abbreviations
\itemize{
\item \code{g} (Genetic component of full liability)
\item \code{o} (Full liability)
\item \code{m} (Mother)
\item \code{f} (Father)
\item \code{c[0-9]*.[0-9]*} (Children)
\item \code{mgm} (Maternal grandmother)
\item \code{mgf} (Maternal grandfather)
\item \code{pgm} (Paternal grandmother)
\item \code{pgf} (Paternal grandfather)
\item \code{s[0-9]*} (Full siblings)
\item \code{mhs[0-9]*} (Half-siblings - maternal side)
\item \code{phs[0-9]*} (Half-siblings - paternal side)
\item \code{mau[0-9]*} (Aunts/Uncles - maternal side)
\item \code{pau[0-9]*} (Aunts/Uncles - paternal side).
Defaults to "role".
}}

\item{out}{A character or numeric vector indicating whether the genetic component
of the full liability, the full liability or both should be returned. If \code{out = c(1)} or
\code{out = c("genetic")}, the genetic liability is estimated and returned. If \code{out = c(2)} or
\code{out = c("full")}, the full liability is estimated and returned. If \code{out = c(1,2)} or
\code{out = c("genetic", "full")}, both components are estimated and returned.
Defaults to \code{c(1)}.}

\item{tol}{A number that is used as the convergence criterion for the Gibbs sampler.
Equals the standard error of the mean. That is, a tolerance of 0.2 means that the
standard error of the mean is below 0.2. Defaults to 0.01.}
}
\value{
If \code{family} and \code{threshs} are two matrices, lists or
data frames that can be converted into tibbles, if \code{family} has two
columns named like the strings represented in \code{pid} and \code{fam_id}, if
\code{threshs} has a column named like the string given in \code{pid} as
well as a column named "lower" and a column named "upper" and if the
liability-scale heritability \code{h2}, \code{out}, \code{tol} and
\code{always_add} are of the required form, then the function returns a
tibble with either four or six columns (depending on the length of out).
The first two columns correspond to the columns \code{fam_id} and \code{pid} '
present in \code{family}.
If \code{out} is equal to \code{c(1)} or \code{c("genetic")}, the third
and fourth column hold the estimated genetic liability as well as the
corresponding standard error, respectively.
If \code{out} equals \code{c(2)} or \code{c("full")}, the third and
fourth column hold the estimated full liability as well as the
corresponding standard error, respectively.
If \code{out} is equal to \code{c(1,2)} or \code{c("genetic","full")},
the third and fourth column hold the estimated genetic liability as
well as the corresponding standard error, respectively, while the fifth and
sixth column hold the estimated full liability as well as the corresponding
standard error, respectively.
}
\description{
\code{estimate_liability_single} estimates the genetic component of the full
liability and/or the full liability for a number of individuals based
on their family history.
}
\details{
This function can be used to estimate either the genetic component of the
full liability, the full liability or both. It is possible to input either
}
\examples{
sims <- simulate_under_LTM(fam_vec = c("m","f","s1"), n_fam = NULL, 
add_ind = TRUE, h2 = 0.5, n_sim=10, pop_prev = .05)
#
estimate_liability_single(.tbl = sims$thresholds, 
h2 = 0.5, pid = "indiv_ID", fam_id = "fam_ID", role = "role", out = c(1), 
tol = 0.01)
# 
sims <- simulate_under_LTM(fam_vec = c(), n_fam = NULL, add_ind = TRUE, 
h2 = 0.5, n_sim=10, pop_prev = .05)
#
estimate_liability_single(.tbl = sims$thresholds, 
h2 = 0.5, pid = "indiv_ID", fam_id = "fam_ID", role = "role",
out = c("genetic"), tol = 0.01)

}
\seealso{
\code{\link[future.apply]{future_apply}}, \code{\link{estimate_liability_multi}},
\code{\link{estimate_liability}}
}
