% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Zagent.R
\name{AgentAction}
\alias{AgentAction}
\title{AgentAction S3 Class}
\usage{
AgentAction(agent, prompt_template, replacements = list(), verbose = FALSE)
}
\arguments{
\item{agent}{An \code{Agent} object.}

\item{prompt_template}{A character string (the prompt).}

\item{replacements}{A named list for placeholder substitution (optional).}

\item{verbose}{Logical. If \code{TRUE}, prints verbose LLM response info. Default \code{FALSE}.}
}
\value{
An object of class \code{AgentAction}, used in conversation chaining.
}
\description{
An object that bundles an Agent together with a prompt and replacements so that
it can be chained onto a conversation with the `+` operator.

When `conversation + AgentAction` is called:
\enumerate{
  \item If the agent is not yet in the conversation, it is added.
  \item The agent is prompted with the provided prompt template (and replacements).
  \item The conversation is updated with the agent's response.
}
}
