% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3print.R
\name{print}
\alias{print}
\alias{print.LCA}
\alias{print.summary.LCA}
\alias{print.LPA}
\alias{print.summary.LPA}
\alias{print.LTA}
\alias{print.summary.LTA}
\alias{print.LCPA}
\alias{print.summary.LCPA}
\alias{print.sim.LCA}
\alias{print.summary.sim.LCA}
\alias{print.sim.LPA}
\alias{print.summary.sim.LPA}
\alias{print.sim.LTA}
\alias{print.summary.sim.LTA}
\alias{print.fit.index}
\alias{print.summary.fit.index}
\alias{print.compare.model}
\alias{print.summary.compare.model}
\alias{print.SE}
\alias{print.summary.SE}
\title{S3 Methods: print}
\usage{
\method{print}{LCA}(x, ...)

\method{print}{summary.LCA}(x, ...)

\method{print}{LPA}(x, ...)

\method{print}{summary.LPA}(x, ...)

\method{print}{LTA}(x, ...)

\method{print}{summary.LTA}(x, ...)

\method{print}{LCPA}(x, ...)

\method{print}{summary.LCPA}(x, ...)

\method{print}{sim.LCA}(x, ...)

\method{print}{summary.sim.LCA}(x, ...)

\method{print}{sim.LPA}(x, ...)

\method{print}{summary.sim.LPA}(x, ...)

\method{print}{sim.LTA}(x, ...)

\method{print}{summary.sim.LTA}(x, ...)

\method{print}{fit.index}(x, ...)

\method{print}{summary.fit.index}(x, ...)

\method{print}{compare.model}(x, ...)

\method{print}{summary.compare.model}(x, ...)

\method{print}{SE}(x, digits = 4, I.max = 5, L.max = 3, ...)

\method{print}{summary.SE}(x, ...)
}
\arguments{
\item{x}{An object of one of the following classes:
\itemize{
\item Model objects: \code{\link[LCPA]{LCA}}, \code{\link[LCPA]{LPA}},
\code{\link[LCPA]{LCPA}}, \code{\link[LCPA]{LTA}}
\item Simulation objects: \code{\link[LCPA]{sim.LCA}}, \code{\link[LCPA]{sim.LPA}},
\code{\link[LCPA]{sim.LTA}}
\item Fit/comparison objects: \code{\link[LCPA]{get.fit.index}}, \code{\link[LCPA]{compare.model}}
\item Standard error objects: \code{\link[LCPA]{get.SE}}
\item Summary objects: \code{summary.LCA}, \code{summary.LPA}, \code{summary.LCPA},
\code{summary.LTA}, \code{summary.sim.LCA}, \code{summary.sim.LPA}, \code{summary.sim.LTA},
\code{summary.fit.index}, \code{summary.compare.model}, \code{summary.SE}
}}

\item{...}{Additional arguments passed to methods (currently ignored in most cases).}

\item{digits}{Number of decimal places for numeric output (default: varies by method, often 4).
Used by: \code{print.SE}, \code{print.summary.fit.index}, \code{print.summary.sim.LCA/LPA/LTA},
\code{print.summary.SE}.}

\item{I.max}{Maximum number of variables/items to display before truncation (default: varies, e.g., 5).
Used by: \code{print.SE}, \code{print.summary.sim.LCA/LPA/LTA}.}

\item{L.max}{Maximum number of latent classes/profiles to display before truncation (default: varies, e.g., 3).
Used by: \code{print.SE}, \code{print.summary.sim.LTA}.}
}
\value{
Invisibly returns the input object \code{x}. No data is modified.
}
\description{
Provides user-friendly, formatted console output for objects generated by the \code{LCPA} package.
This generic function dispatches to class-specific methods that display concise summaries of model results,
simulated datasets, fit indices, model comparisons, and standard errors. Designed for interactive use
and quick diagnostic inspection.
}
\details{
Each method produces a structured, human-readable summary optimized for its object type:

\describe{
\item{\strong{Model Objects (\code{LCA}/\code{LPA}/\code{LCPA}/\code{LTA})}}{
Invokes \code{summary()} internally and prints comprehensive output including:
\itemize{
\item Model call and configuration (method, constraints, reference class)
\item Data characteristics (N, I, time points, distribution)
\item Fit statistics (LogLik, AIC, BIC, entropy, npar)
\item Class/profile prior probabilities and frequencies
\item Item-response probabilities (\code{LCA}) or profile means (\code{LPA})
\item For \code{LCPA}/\code{LTA}: regression coefficients with significance markers and 95\% CIs
\item Convergence diagnostics (iterations, tolerance, hardware)
\item Replication details (if \code{nrep > 1})
}
}

\item{\strong{Simulation Objects (\code{sim.LCA}/\code{sim.LPA}/\code{sim.LTA})}}{
Displays simulation design and true parameter structure:
\itemize{
\item Configuration (N, I, L, times, constraint, distribution)
\item True class/profile proportions and observed frequencies
\item For \code{sim.LCA}: item category structure and conditional probabilities
\item For \code{sim.LPA}: covariance constraint description and mean ranges
\item For \code{sim.LTA}: transition mode (fixed/covariate), initial/transition coefficients
}
Output is truncated for high-dimensional structures using \code{I.max} and \code{L.max}.
}

\item{\strong{Fit Index Objects (\code{fit.index})}}{
Presents a clean table of model fit criteria:
\itemize{
\item Header with dimensions (N, I, L, npar)
\item Formatted table: AIC, BIC, SABIC, CAIC, AWE, -2LL, SIC
\item Interpretation note: “Lower values preferred for ICs”
\item Values rounded to \code{digits} decimal places
}
}

\item{\strong{Model Comparison Objects (\code{compare.model})}}{
Compares two nested models with statistical tests:
\itemize{
\item Comparative fit table (npar, LogLik, AIC, BIC, entropy)
\item Classification quality (AvePP per class, overall entropy)
\item Bayes Factor with interpretive guidance
\item Likelihood ratio tests (standard, VLMR, Bootstrap) with p-values and significance codes
\item Clear section headers and visual separators
}
}

\item{\strong{Standard Error Objects (\code{SE})}}{
Displays uncertainty estimates for model parameters:
\itemize{
\item Class probability SEs (always fully shown)
\item Profile means SEs (\code{LPA}) or item-response SEs (\code{LCA}), truncated by \code{L.max}/\code{I.max}
\item Covariance SE summary (non-zero count only; full access via \code{extract()})
\item Diagnostics: Bootstrap completion \% or Hessian condition number with stability warnings
}
}

\item{\strong{Summary Objects}}{
All \code{summary.*} methods are called internally by their corresponding \code{print.*} methods.
They pre-compute and structure output for consistent formatting. Direct calls are also supported.
}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{print(LCA)}: Print method for \code{LCA} objects

\item \code{print(summary.LCA)}: Print method for \code{summary.LCA} objects

\item \code{print(LPA)}: Print method for \code{LPA} objects

\item \code{print(summary.LPA)}: Print method for \code{summary.LPA} objects

\item \code{print(LTA)}: Print method for \code{LTA} objects

\item \code{print(summary.LTA)}: Print method for \code{summary.LTA} objects

\item \code{print(LCPA)}: Print method for \code{LCPA} objects

\item \code{print(summary.LCPA)}: Print method for \code{summary.LCPA} objects

\item \code{print(sim.LCA)}: Print method for \code{sim.LCA} objects

\item \code{print(summary.sim.LCA)}: Print method for \code{summary.sim.LCA} objects

\item \code{print(sim.LPA)}: Print method for \code{sim.LPA} objects

\item \code{print(summary.sim.LPA)}: Print method for \code{summary.sim.LPA} objects

\item \code{print(sim.LTA)}: Print method for \code{sim.LTA} objects

\item \code{print(summary.sim.LTA)}: Print method for \code{summary.sim.LTA} objects

\item \code{print(fit.index)}: Print method for \code{fit.index} objects

\item \code{print(summary.fit.index)}: Print method for \code{summary.fit.index} objects

\item \code{print(compare.model)}: Print method for \code{compare.model} objects

\item \code{print(summary.compare.model)}: Print method for \code{summary.compare.model} objects

\item \code{print(SE)}: Print method for \code{SE} objects

\item \code{print(summary.SE)}: Print method for summary.SE objects

}}
\section{Output Conventions}{

\itemize{
\item Numeric values are typically rounded to 4 decimal places unless overridden by \code{digits}.
\item Large matrices (e.g., item parameters, transition coefficients) are truncated with clear messages.
\item Significance markers: \code{***} (<0.001), \code{**} (<0.01), \code{*} (<0.05), \code{.} (<0.1).
\item 95\% confidence intervals computed as: Estimate ± 1.96 × Std_Error.
\item Reference classes (for multinomial models) are explicitly stated.
\item Warnings appear for unstable SEs (high condition number) or incomplete Bootstrap runs.
}
}

